/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl;

import com.google.common.collect.Lists;
import com.sap.cds.CdsDataProcessor;
import com.sap.cds.ql.cqn.Path;
import com.sap.cds.ql.cqn.ResolvedSegment;
import com.sap.cds.ql.impl.PathImpl;
import com.sap.cds.reflect.CdsArrayedType;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsSimpleType;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.util.CdsModelUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class DataProcessor
implements CdsDataProcessor {
    private final List<Action> actions = new ArrayList<Action>();
    private CdsModelUtils.CascadeType cascadeType;
    private boolean depthFirst;

    public static DataProcessor create() {
        return new DataProcessor();
    }

    public DataProcessor forInsert() {
        this.cascadeType = CdsModelUtils.CascadeType.INSERT;
        return this;
    }

    public DataProcessor forUpdate() {
        this.cascadeType = CdsModelUtils.CascadeType.UPDATE;
        return this;
    }

    public DataProcessor withDepthFirst() {
        this.depthFirst = true;
        return this;
    }

    public CdsDataProcessor action(Action action) {
        this.actions.add(action);
        return this;
    }

    public DataProcessor action(final BiConsumer<CdsStructuredType, Map<String, Object>> action) {
        this.actions.add(new Action(){

            @Override
            public void entry(Path path, CdsElement unused, CdsStructuredType type, Map<String, Object> entry) {
                action.accept(type, entry);
            }
        });
        return this;
    }

    public DataProcessor bulkAction(final BiConsumer<CdsStructuredType, Iterable<Map<String, Object>>> action) {
        this.actions.add(new Action(){

            @Override
            public void entries(Path path, CdsElement unused, CdsStructuredType type, Iterable<Map<String, Object>> entries) {
                action.accept(type, entries);
            }
        });
        return this;
    }

    public DataProcessor addConverter(final CdsDataProcessor.Filter filter, final CdsDataProcessor.Converter valConverter) {
        this.actions.add(new Action(){

            @Override
            public void entries(Path path2e, CdsElement e, CdsStructuredType type, Iterable<Map<String, Object>> entries) {
                DataProcessor.forAllEntries(DataProcessor.path(path2e, e, type), entries, type, filter, (element, entry) -> {
                    if (entry.containsKey(element.getName())) {
                        Path path = DataProcessor.path(path2e, e, type, entry);
                        String name = element.getName();
                        Object value = entry.get(name);
                        this.convert(path, (CdsElement)element, (Map<String, Object>)entry, name, value, valConverter);
                    }
                });
            }

            private void convert(Path path, CdsElement element, Map<String, Object> entry, String name, Object value, CdsDataProcessor.Converter converter) {
                if (value instanceof List) {
                    List list = (List)value;
                    ListIterator<Object> iterator = list.listIterator();
                    while (iterator.hasNext()) {
                        Object val = converter.convert(path, element, iterator.next());
                        if (val == CdsDataProcessor.Converter.REMOVE) {
                            iterator.remove();
                            continue;
                        }
                        iterator.set(val);
                    }
                } else {
                    Object val = converter.convert(path, element, entry.get(name));
                    if (val == CdsDataProcessor.Converter.REMOVE) {
                        entry.remove(name);
                    } else {
                        entry.put(name, val);
                    }
                }
            }

            @Override
            public void array(Path path, CdsElement element, CdsSimpleType type, List<Object> items) {
                if (filter.test(path, element, (CdsType)type)) {
                    for (int i = 0; i < items.size(); ++i) {
                        items.set(i, valConverter.convert(path, element, items.get(i)));
                    }
                }
            }
        });
        return this;
    }

    public DataProcessor addGenerator(final CdsDataProcessor.Filter filter, final CdsDataProcessor.Generator valGenerator) {
        this.actions.add(new Action(){

            @Override
            public void entries(Path path, CdsElement element, CdsStructuredType type, Iterable<Map<String, Object>> entries) {
                type.concreteNonAssociationElements().filter(e -> filter.test(DataProcessor.path(path, element, type), e)).forEach(e -> entries.forEach(entry -> {
                    String name = e.getName();
                    if (entry.get(name) == null) {
                        entry.put(name, valGenerator.generate(DataProcessor.path(path, element, type, entry), e, entry.containsKey(name)));
                    }
                }));
            }
        });
        return this;
    }

    public DataProcessor addValidator(final CdsDataProcessor.Filter filter, final CdsDataProcessor.Validator validator, final CdsDataProcessor.Mode mode) {
        this.actions.add(new Action(){
            final Handler handler;
            {
                this.handler = DataProcessor.validationHandler(mode);
            }

            @Override
            public void entries(Path path2e, CdsElement e, CdsStructuredType type, Iterable<Map<String, Object>> entries) {
                DataProcessor.forAllEntries(DataProcessor.path(path2e, e, type), entries, type, filter, (element, entry) -> {
                    Path path = DataProcessor.path(path2e, e, type, entry);
                    this.handler.apply((Map<String, Object>)entry, element.getName(), value -> this.validate(path, (CdsElement)element, value, validator));
                });
            }

            private void validate(Path path, CdsElement element, Object value, CdsDataProcessor.Validator validator2) {
                if (value instanceof List) {
                    ((List)value).forEach(v -> validator2.validate(path, element, v));
                } else {
                    validator2.validate(path, element, value);
                }
            }

            @Override
            public void array(Path path, CdsElement element, CdsSimpleType type, List<Object> items) {
                if (filter.test(path, element, (CdsType)type)) {
                    items.forEach(value -> validator.validate(path, element, value));
                }
            }
        });
        return this;
    }

    private static Handler validationHandler(CdsDataProcessor.Mode mode) {
        switch (mode) {
            case DECLARED: {
                return (map, key, consumer) -> {
                    Object value = map.getOrDefault(key, CdsDataProcessor.ABSENT);
                    consumer.accept(value);
                };
            }
            case NOT_NULL: {
                return (map, key, consumer) -> {
                    Object value = map.get(key);
                    if (value != null) {
                        consumer.accept(value);
                    }
                };
            }
            case NULL: {
                return (map, key, consumer) -> {
                    Object value = map.getOrDefault(key, CdsDataProcessor.ABSENT);
                    if (value == null || value == CdsDataProcessor.ABSENT) {
                        consumer.accept(value);
                    }
                };
            }
        }
        return (map, key, consumer) -> {
            if (map.containsKey(key)) {
                consumer.accept(map.get(key));
            }
        };
    }

    private static Path path(Path path, CdsElement e, CdsStructuredType type) {
        return ((PathImpl)path).append(e, type, new HashMap<String, Object>());
    }

    private static Path path(Path path, CdsElement e, CdsStructuredType type, Map<String, Object> entry) {
        return ((PathImpl)path).append(e, type, entry);
    }

    private static void forAllEntries(Path path, Iterable<Map<String, Object>> entries, CdsStructuredType type, CdsDataProcessor.Filter filter, BiConsumer<CdsElement, Map<String, Object>> handler) {
        type.elements().filter(e -> filter.test(path, e, e.getType())).forEach(element -> entries.forEach(entry -> handler.accept((CdsElement)element, (Map<String, Object>)entry)));
    }

    public void process(Map<String, Object> entry, CdsStructuredType entryType) {
        this.process(Arrays.asList(entry), entryType);
    }

    public void process(Iterable<? extends Map<String, Object>> entries, CdsStructuredType entryType) {
        if (entryType == null) {
            throw new IllegalArgumentException("Entry type must not be null");
        }
        PathImpl path = new PathImpl(new LinkedList<ResolvedSegment>());
        this.executeAndTraverse(() -> this.performActions(path, null, entryType, entries), () -> this.traverseEntries(path, null, entryType, entries));
    }

    private void performActions(Path path, CdsElement element, CdsStructuredType type, Iterable<Map<String, Object>> entries) {
        this.actions.stream().forEach(action -> action.entries(path, element, type, entries));
    }

    private void performActions(Path path, CdsElement element, CdsStructuredType type, Map<String, Object> entry) {
        this.actions.stream().forEach(action -> action.entry(path, element, type, entry));
    }

    private void performActions(Path path, CdsElement element, CdsSimpleType type, List<Object> items) {
        for (Action action : this.actions) {
            action.array(path, element, type, items);
        }
    }

    private void traverseEntries(Path path, CdsElement element, CdsStructuredType struct, Iterable<? extends Map<String, Object>> entries) {
        entries.forEach(entry -> entry.forEach((key, value) -> {
            if (value instanceof List) {
                struct.findElement(key).filter(this::cascade).ifPresent(e -> this.traverseMany(DataProcessor.path(path, element, struct, entry), (CdsElement)e, (List)value));
            } else if (value instanceof Map) {
                struct.findElement(key).filter(this::cascade).ifPresent(e -> this.traverseOne(DataProcessor.path(path, element, struct, entry), (CdsElement)e, (Map)value));
            }
        }));
    }

    private boolean cascade(CdsElement e) {
        return this.cascadeType == null || !e.getType().isAssociation() || CdsModelUtils.isCascading(this.cascadeType, e);
    }

    private void traverseOne(Path path, CdsElement element, Map<String, Object> entry) {
        CdsStructuredType struct = DataProcessor.struct(element);
        this.executeAndTraverse(() -> this.performActions(path, element, struct, entry), () -> this.traverseEntries(path, element, struct, Arrays.asList(entry)));
    }

    private void traverseMany(Path path, CdsElement element, List<?> entries) {
        CdsType type = DataProcessor.type(element);
        if (type.isSimple()) {
            this.performActions(path, element, (CdsSimpleType)type.as(CdsSimpleType.class), entries);
        } else {
            CdsStructuredType struct = (CdsStructuredType)type.as(CdsStructuredType.class);
            List<Object> structEntries = entries;
            this.executeAndTraverse(() -> this.performActions(path, element, struct, structEntries), () -> this.traverseEntries(path, element, struct, structEntries));
        }
    }

    private void executeAndTraverse(Runnable execution, Runnable traversal) {
        if (this.depthFirst) {
            traversal.run();
            execution.run();
        } else {
            execution.run();
            traversal.run();
        }
    }

    private static CdsStructuredType struct(CdsElement element) {
        CdsType type = element.getType();
        if (type.isAssociation()) {
            return ((CdsAssociationType)type.as(CdsAssociationType.class)).getTarget();
        }
        return (CdsStructuredType)type.as(CdsStructuredType.class);
    }

    private static CdsType type(CdsElement element) {
        CdsType type = element.getType();
        if (type.isArrayed()) {
            return ((CdsArrayedType)type.as(CdsArrayedType.class)).getItemsType();
        }
        return DataProcessor.struct(element);
    }

    public static interface Action {
        default public void entry(Path path, CdsElement element, CdsStructuredType type, Map<String, Object> entry) {
            this.entries(path, element, type, Lists.newArrayList((Object[])new Map[]{entry}));
        }

        default public void entries(Path path, CdsElement element, CdsStructuredType type, Iterable<Map<String, Object>> entries) {
            entries.forEach(entry -> this.entry(path, element, type, (Map<String, Object>)entry));
        }

        default public void array(Path path, CdsElement element, CdsSimpleType type, List<Object> items) {
        }
    }

    @FunctionalInterface
    private static interface Handler {
        public void apply(Map<String, Object> var1, String var2, Consumer<Object> var3);
    }
}

