/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl;

import com.google.common.collect.ForwardingMap;
import com.google.common.collect.Maps;
import com.sap.cds.CdsDataStore;
import com.sap.cds.NonUniqueResultException;
import com.sap.cds.Row;
import com.sap.cds.impl.Lazy;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.cqn.CqnSelect;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public class LazyRowImpl
extends ForwardingMap<String, Object>
implements Row,
Lazy {
    private final Supplier<Row> rowSupplier;
    private boolean loaded;
    private Row row;

    public LazyRowImpl(Supplier<Row> rowSupplier) {
        this.rowSupplier = rowSupplier;
    }

    public static LazyRowImpl lazyRow(CdsDataStore dataStore, CqnSelect query) {
        return new LazyRowImpl(() -> {
            List result = dataStore.execute(query, new Object[0]).list();
            if (result.size() == 1) {
                return (Row)result.get(0);
            }
            if (result.size() > 1) {
                throw new NonUniqueResultException("Query for single-valued association returned multiple rows");
            }
            return null;
        });
    }

    private Row data() {
        if (!this.loaded) {
            this.load();
        }
        return this.row;
    }

    public String toJson() {
        return this.row != null ? this.row.toJson() : null;
    }

    public String toString() {
        return this.toJson();
    }

    protected Map<String, Object> delegate() {
        return this.data();
    }

    public <T> T as(Class<T> type) {
        return (T)this.data().as(type);
    }

    @Override
    public void load() {
        this.row = this.rowSupplier.get();
        this.loaded = true;
    }

    @Override
    public boolean isLoaded() {
        return this.loaded;
    }

    @Override
    public Object loadData() {
        Row data = this.data();
        return data != null ? Maps.newHashMap((Map)data) : null;
    }

    public StructuredType<?> ref() {
        return this.data().ref();
    }

    public <T> T getPath(String path) {
        return (T)this.data().getPath(path);
    }

    public <T> T getPathOrDefault(String path, T defaultValue) {
        return (T)this.data().getPathOrDefault(path, defaultValue);
    }

    public <T> T putPath(String path, T value) {
        return (T)this.data().putPath(path, value);
    }

    public <T> T putPathIfAbsent(String path, T value) {
        return (T)this.data().putPathIfAbsent(path, value);
    }

    public boolean containsPath(String path) {
        return this.data().containsPath(path);
    }

    public <T> T removePath(String path) {
        return (T)this.data().removePath(path);
    }
}

