/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl;

import com.sap.cds.impl.ProxyCreator;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class ProxyList<E extends Map<String, Object>>
implements List<E> {
    private final List<Map<String, Object>> list;
    private final Class<E> proxyInterface;
    private final Map<Method, ProxyCreator.Delegate> proxyMapping;

    public ProxyList(List<Map<String, Object>> list, Class<E> proxyInterface) {
        this.list = list;
        this.proxyInterface = proxyInterface;
        this.proxyMapping = ProxyCreator.createMapping(proxyInterface);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return new ProxyIterator(this.list.iterator());
    }

    @Override
    public Object[] toArray() {
        int size = this.list.size();
        Object[] array = new Object[size];
        for (int i = 0; i < size; ++i) {
            array[i] = this.get(i);
        }
        return array;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        Object[] array = this.toArray();
        if (a.length < array.length) {
            return Arrays.copyOf(array, array.length, a.getClass());
        }
        System.arraycopy(array, 0, a, 0, array.length);
        if (a.length > array.length) {
            a[array.length] = null;
        }
        return a;
    }

    @Override
    public boolean add(E e) {
        return this.list.add((Map<String, Object>)e);
    }

    @Override
    public boolean remove(Object o) {
        return this.list.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.list.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        return this.list.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.list.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.list.retainAll(c);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public E get(int index) {
        return this.proxy(this.list.get(index));
    }

    @Override
    public E set(int index, E element) {
        return this.proxy(this.list.set(index, (Map<String, Object>)element));
    }

    @Override
    public void add(int index, E element) {
        this.list.add(index, (Map<String, Object>)element);
    }

    @Override
    public E remove(int index) {
        return this.proxy(this.list.remove(index));
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return new ProxyList<E>(this.list.subList(fromIndex, toIndex), this.proxyInterface);
    }

    private E proxy(Map<String, Object> value) {
        return (E)(value != null ? (Map)ProxyCreator.createProxy(value, this.proxyInterface, this.proxyMapping) : null);
    }

    private class ProxyIterator
    implements Iterator<E> {
        private final Iterator<Map<String, Object>> iterator;

        public ProxyIterator(Iterator<Map<String, Object>> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public E next() {
            return ProxyList.this.proxy(this.iterator.next());
        }
    }
}

