/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl;

import com.google.common.collect.Lists;
import com.sap.cds.EmptyResultException;
import com.sap.cds.NonUniqueResultException;
import com.sap.cds.Result;
import com.sap.cds.ResultBuilder;
import com.sap.cds.Row;
import com.sap.cds.impl.RowImpl;
import com.sap.cds.impl.parser.token.Jsonizer;
import com.sap.cds.reflect.CdsStructuredType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class ResultImpl
extends ResultBuilder {
    private CdsStructuredType rowType;
    private List<Row> rows = new ArrayList<Row>(0);
    private long[] rowCounts = new long[0];
    private long inlineCount = -1L;

    public static ResultImpl from(Result result) {
        if (!(result instanceof MaterializedResult)) {
            throw new UnsupportedOperationException("Result builder not yet supported for type: " + result.getClass().getName());
        }
        ResultImpl builder = new ResultImpl();
        MaterializedResult r = (MaterializedResult)result;
        builder.rowType = r.rowType;
        builder.rows = new ArrayList<Row>();
        r.rows.forEach(builder.rows::add);
        builder.rowCounts = r.rowCount;
        builder.inlineCount = r.inlineCount;
        return builder;
    }

    public ResultImpl rows(List<? extends Map<String, ?>> rows) {
        return this.rows(rows.stream());
    }

    public ResultImpl rowType(CdsStructuredType rowType) {
        this.rowType = rowType;
        return this;
    }

    public ResultImpl rows(Stream<? extends Map<String, ?>> rows) {
        this.rows = rows.map(RowImpl::row).collect(Collectors.toList());
        return this;
    }

    public ResultImpl rowCount(long[] rc) {
        this.rowCounts = Arrays.copyOf(rc, rc.length);
        return this;
    }

    public ResultImpl inlineCount(long inlineCount) {
        this.inlineCount = inlineCount;
        return this;
    }

    public Result result() {
        return new MaterializedResult(this.rowType, this.rows, this.rowCounts, this.inlineCount);
    }

    private static long countRows(long[] counts) {
        return Arrays.stream(counts).sum();
    }

    public ResultBuilder addUpdatedRows(long updateCount, Map<String, ?> updateData) {
        int length = this.rowCounts.length;
        long[] newCounts = new long[length + 1];
        System.arraycopy(this.rowCounts, 0, newCounts, 0, length);
        newCounts[length] = updateCount;
        this.rowCounts = newCounts;
        if (updateCount == 0L) {
            updateData = new HashMap();
        }
        this.rows.add(RowImpl.row(updateData));
        return this;
    }

    public static class Factory
    implements ResultBuilder.Factory {
        public ResultBuilder create() {
            return new ResultImpl();
        }
    }

    private static class MaterializedResult
    implements Result {
        private final CdsStructuredType rowType;
        private final Iterable<Row> rows;
        private final long[] rowCount;
        private final long inlineCount;

        public MaterializedResult(CdsStructuredType rowType, Iterable<Row> rows, long[] rowCount, long inlineCount) {
            this.rowType = rowType;
            this.rows = rows;
            this.rowCount = rowCount;
            this.inlineCount = inlineCount;
        }

        public CdsStructuredType rowType() {
            return this.rowType;
        }

        public String toJson() {
            return Jsonizer.json(this.rows);
        }

        public String toString() {
            return this.toJson();
        }

        public Iterator<Row> iterator() {
            return this.rows.iterator();
        }

        public Row single() {
            Iterator<Row> iterator = this.iterator();
            if (!iterator.hasNext()) {
                throw new EmptyResultException("Result is empty");
            }
            Row row = iterator.next();
            if (iterator.hasNext()) {
                throw new NonUniqueResultException("Result contains more than one row");
            }
            return row;
        }

        public <T> T single(Class<T> type) {
            return (T)this.single().as(type);
        }

        public Optional<Row> first() {
            return this.stream().findFirst();
        }

        public <T> Optional<T> first(Class<T> type) {
            return this.stream().findFirst().map(row -> row.as(type));
        }

        public Stream<Row> stream() {
            return StreamSupport.stream(this.rows.spliterator(), false);
        }

        public <T> Stream<T> streamOf(Class<T> type) {
            return this.stream().map(row -> row.as(type));
        }

        public List<Row> list() {
            return Lists.newArrayList(this.rows.iterator());
        }

        public <T> List<T> listOf(Class<T> type) {
            return this.streamOf(type).collect(Collectors.toList());
        }

        public long rowCount() {
            return ResultImpl.countRows(this.rowCount);
        }

        public long rowCount(int batch) {
            return this.rowCount[batch];
        }

        public int batchCount() {
            return this.rowCount.length;
        }

        public long inlineCount() {
            return this.inlineCount;
        }
    }
}

