/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl;

import com.google.common.collect.ForwardingMap;
import com.sap.cds.CdsData;
import com.sap.cds.CdsException;
import com.sap.cds.Row;
import com.sap.cds.Struct;
import com.sap.cds.impl.parser.token.Jsonizer;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.util.DataUtils;
import java.util.Map;

public class RowImpl
extends ForwardingMap<String, Object>
implements Row {
    private final StructuredType<?> selfRef;
    private final Map<String, Object> data;

    private RowImpl(Map<String, Object> data, StructuredType<?> selfRef) {
        this.data = data;
        this.selfRef = selfRef;
    }

    public static Row row(Map<String, ?> data) {
        if (data instanceof Row) {
            return (Row)data;
        }
        return new RowImpl(data, null);
    }

    public static Row row(Map<String, ?> data, StructuredType<?> selfRef) {
        return new RowImpl(data, selfRef);
    }

    public boolean containsPath(String path) {
        return DataUtils.containsKey(this.data, path);
    }

    public <T> T removePath(String path) {
        Object value = DataUtils.removePath(this.data, path, true);
        return this.mapToRow(value);
    }

    public <T> T putPath(String path, T value) {
        Object oldValue = DataUtils.putPath(this.data, path, value);
        return (T)this.mapToRow(oldValue);
    }

    public <T> T putPathIfAbsent(String path, T value) {
        T v = this.getPath(path);
        if (v == null) {
            this.putPath(path, value);
        }
        return v;
    }

    public Object get(Object key) {
        if (key instanceof String) {
            Object value = DataUtils.getOrDefault(this.data, (String)key, null);
            return this.mapToRow(value);
        }
        return this.data.get(key);
    }

    public <T> T getPath(String path) {
        return this.getPathOrDefault(path, null);
    }

    public <T> T getPathOrDefault(String path, T defaultValue) {
        T value = DataUtils.getPathOrDefault(this.data, path, defaultValue);
        return this.mapToRow(value);
    }

    private <T> T mapToRow(T value) {
        if (value instanceof Map && !(value instanceof CdsData)) {
            return (T)RowImpl.row((Map)value);
        }
        return value;
    }

    public StructuredType<?> ref() {
        if (this.selfRef != null) {
            return this.selfRef;
        }
        throw new CdsException("Row does not reference an entity");
    }

    public String toJson() {
        return Jsonizer.json((Object)this);
    }

    protected Map<String, Object> delegate() {
        return this.data;
    }

    public <T> T as(Class<T> type) {
        return (T)Struct.access((Map)((Object)this)).as(type);
    }
}

