/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl;

import java.util.function.Supplier;
import org.slf4j.Logger;

public class TimingLogger {
    private Logger logger;

    public TimingLogger(Logger logger) {
        this.logger = logger;
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public <T> T debug(Job<T> job, String message) {
        this.logger.debug("{} started", (Object)message);
        Result<T> r = TimingLogger.time(job);
        this.logger.debug("{} in {} ms", (Object)message, (Object)((Result)r).ms);
        return (T)((Result)r).result;
    }

    public <T> T debug(Job<T> job, String format, Object ... args) {
        if (!this.isDebugEnabled()) {
            return job.run();
        }
        this.logger.debug(format + " started", args);
        Result<T> r = TimingLogger.time(job);
        int n = args.length;
        Object[] argsMs = new Object[n + 1];
        System.arraycopy(args, 0, argsMs, 0, n);
        argsMs[n] = ((Result)r).ms;
        this.logger.debug(format + " in {} ms", argsMs);
        return (T)((Result)r).result;
    }

    public <T> T debug(Job<T> job, String format, Supplier<Object[]> argsSupplier) {
        if (!this.isDebugEnabled()) {
            return job.run();
        }
        return this.debug(job, format, argsSupplier.get());
    }

    private static <T> Result<T> time(Job<T> job) {
        long start = System.currentTimeMillis();
        T result = job.run();
        long ms = System.currentTimeMillis() - start;
        return new Result<T>(result, ms);
    }

    private static class Result<T> {
        private T result;
        private long ms;

        public Result(T result, long ms) {
            this.result = result;
            this.ms = ms;
        }
    }

    public static interface Job<R> {
        public R run();
    }
}

