/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.builder.model;

import com.sap.cds.CdsException;
import com.sap.cds.impl.builder.model.ArithmeticExpr;
import com.sap.cds.impl.builder.model.BetweenPredicate;
import com.sap.cds.impl.builder.model.BooleanFunctionCall;
import com.sap.cds.impl.builder.model.ComparisonPredicate;
import com.sap.cds.impl.builder.model.ContainmentTest;
import com.sap.cds.impl.builder.model.CqnNull;
import com.sap.cds.impl.builder.model.InPredicate;
import com.sap.cds.impl.builder.model.LiteralImpl;
import com.sap.cds.impl.builder.model.ScalarFunctionCall;
import com.sap.cds.impl.parser.builder.ExpressionBuilder;
import com.sap.cds.impl.parser.builder.SortSpecificationImpl;
import com.sap.cds.impl.parser.token.Jsonizer;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Literal;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.CqnSelectListValue;
import com.sap.cds.ql.cqn.CqnSortSpecification;
import com.sap.cds.ql.cqn.CqnToken;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.impl.SelectListValueBuilder;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.util.CdsTypeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.StreamSupport;

public abstract class AbstractValue<T>
implements Value<T> {
    private String cdsType;

    protected AbstractValue() {
    }

    public Predicate eq(T t) {
        return ComparisonPredicate.eq((CqnValue)this, AbstractValue.value(t));
    }

    public Predicate eq(Value<T> t) {
        return ComparisonPredicate.eq((CqnValue)this, AbstractValue.value(t));
    }

    public Predicate ne(T t) {
        return ComparisonPredicate.ne((CqnValue)this, AbstractValue.value(t));
    }

    public Predicate ne(Value<T> t) {
        return ComparisonPredicate.ne((CqnValue)this, AbstractValue.value(t));
    }

    public Predicate is(T t) {
        return ComparisonPredicate.is((CqnValue)this, AbstractValue.value(t));
    }

    public Predicate is(Value<T> t) {
        return ComparisonPredicate.is((CqnValue)this, AbstractValue.value(t));
    }

    public Predicate isNot(T t) {
        return this.is(t).not();
    }

    public Predicate isNot(Value<T> t) {
        return this.is(t).not();
    }

    public Predicate isNull() {
        return this.is(CqnNull.getInstance());
    }

    public Predicate isNotNull() {
        return this.isNot(CqnNull.getInstance());
    }

    public Predicate gt(T t) {
        return ComparisonPredicate.gt((CqnValue)this, AbstractValue.value(t));
    }

    public Predicate gt(Value<T> t) {
        return ComparisonPredicate.gt((CqnValue)this, AbstractValue.value(t));
    }

    public Predicate ge(T t) {
        return ComparisonPredicate.ge((CqnValue)this, AbstractValue.value(t));
    }

    public Predicate ge(Value<T> t) {
        return ComparisonPredicate.ge((CqnValue)this, AbstractValue.value(t));
    }

    public Predicate lt(T t) {
        return ComparisonPredicate.lt((CqnValue)this, AbstractValue.value(t));
    }

    public Predicate lt(Value<T> t) {
        return ComparisonPredicate.lt((CqnValue)this, AbstractValue.value(t));
    }

    public Predicate le(T t) {
        return ComparisonPredicate.le((CqnValue)this, AbstractValue.value(t));
    }

    public Predicate le(Value<T> t) {
        return ComparisonPredicate.le((CqnValue)this, AbstractValue.value(t));
    }

    public Predicate in(T ... vs) {
        return InPredicate.in((CqnValue)this, Arrays.stream(vs).map(LiteralImpl::val));
    }

    public Predicate in(Value<T> ... vs) {
        return InPredicate.in((CqnValue)this, Arrays.stream(vs));
    }

    public Predicate in(List<? extends T> vs) {
        return InPredicate.in((CqnValue)this, vs.stream().map(LiteralImpl::val));
    }

    public Predicate in(Iterable<Value<? extends T>> ts) {
        return InPredicate.in((CqnValue)this, StreamSupport.stream(ts.spliterator(), false));
    }

    public Predicate between(T low, T high) {
        return this.between((Value<T>)LiteralImpl.val(low), (Value<T>)LiteralImpl.val(high));
    }

    public Predicate between(Value<T> low, T high) {
        return this.between(low, (Value<T>)LiteralImpl.val(high));
    }

    public Predicate between(T low, Value<T> high) {
        return this.between((Value<T>)LiteralImpl.val(low), high);
    }

    public Predicate between(Value<T> low, Value<T> high) {
        return BetweenPredicate.between((CqnValue)this, low, high);
    }

    public Predicate plain(Object ... os) {
        ExpressionBuilder builder = ExpressionBuilder.create(new CqnToken[]{this});
        for (Object o : os) {
            builder.plain(o);
        }
        return builder.predicate();
    }

    public Predicate contains(String substring) {
        return this.contains((Value<String>)LiteralImpl.val(substring));
    }

    public Predicate contains(Value<String> val) {
        return this.contains(val, false);
    }

    public Predicate contains(Value<String> val, boolean caseInsensitive) {
        return ContainmentTest.contains((CqnValue)this, val, caseInsensitive);
    }

    public Predicate startsWith(String prefix) {
        return this.startsWith((Value<String>)LiteralImpl.val(prefix));
    }

    public Predicate startsWith(Value<String> val) {
        return ContainmentTest.startsWith((CqnValue)this, val);
    }

    public Predicate endsWith(String suffix) {
        return this.endsWith((Value<String>)LiteralImpl.val(suffix));
    }

    public Predicate endsWith(Value<String> val) {
        return ContainmentTest.endsWith((CqnValue)this, val);
    }

    public Predicate func(String functionName, Value<?> ... args) {
        ArrayList allArgs = new ArrayList(args.length + 1);
        allArgs.add(this);
        allArgs.addAll(Arrays.asList(args));
        return BooleanFunctionCall.create(functionName, allArgs);
    }

    public Value<Number> plus(Number s) {
        return this.plus((Value<? extends Number>)LiteralImpl.val(s));
    }

    public Value<Number> plus(Value<? extends Number> s) {
        return ArithmeticExpr.plus((CqnValue)this, s);
    }

    public Value<Number> minus(Number s) {
        return this.minus((Value<? extends Number>)LiteralImpl.val(s));
    }

    public Value<Number> minus(Value<? extends Number> s) {
        return ArithmeticExpr.minus((CqnValue)this, s);
    }

    public Value<Number> times(Number f) {
        return this.times((Value<? extends Number>)LiteralImpl.val(f));
    }

    public Value<Number> times(Value<? extends Number> f) {
        return ArithmeticExpr.times((CqnValue)this, f);
    }

    public Value<Number> dividedBy(Number d) {
        return this.dividedBy((Value<? extends Number>)LiteralImpl.val(d));
    }

    public Value<Number> dividedBy(Value<? extends Number> d) {
        return ArithmeticExpr.dividedBy((CqnValue)this, d);
    }

    public Value<String> substring(Value<Integer> start, Value<Integer> length) {
        return ScalarFunctionCall.create("substring", new CqnValue[]{this, start, length});
    }

    public Value<String> toUpper() {
        try {
            return CQL.toUpper((Value)this);
        }
        catch (ClassCastException e) {
            throw new CdsException("toUpper can only be called on String values. ", (Throwable)e);
        }
    }

    public Value<String> toLower() {
        try {
            return CQL.toLower((Value)this);
        }
        catch (ClassCastException e) {
            throw new CdsException("toLower can only be called on String values. ", (Throwable)e);
        }
    }

    public Value<T> min() {
        return CQL.min((CqnValue)this).type(this.cdsType);
    }

    public Value<T> max() {
        return CQL.max((CqnValue)this).type(this.cdsType);
    }

    public Value<Number> sum() {
        return CQL.sum((CqnValue)this);
    }

    public Value<Number> average() {
        return CQL.average((CqnValue)this);
    }

    public Value<Long> countDistinct() {
        return CQL.countDistinct((CqnValue)this).type(CdsBaseType.INTEGER64);
    }

    public Value<String> substring(int start, int length) {
        if (start < 0) {
            throw new IllegalArgumentException("The start position of a substring must not be negative");
        }
        if (length < 0) {
            throw new IllegalArgumentException("The length of a substring must not be negative");
        }
        return this.substring((Value<Integer>)LiteralImpl.val(start), (Value<Integer>)LiteralImpl.val(length));
    }

    public Value<String> substring(Value<Integer> start) {
        return ScalarFunctionCall.create("substring", new CqnValue[]{this, start});
    }

    public Value<String> substring(int start) {
        if (start < 0) {
            throw new IllegalArgumentException("The start position of a substring must not be negative");
        }
        return this.substring((Value<Integer>)LiteralImpl.val(start));
    }

    public CqnSortSpecification asc() {
        return SortSpecificationImpl.sort((CqnValue)this, CqnSortSpecification.Order.ASC);
    }

    public CqnSortSpecification ascNullsLast() {
        return SortSpecificationImpl.sort((CqnValue)this, CqnSortSpecification.Order.ASC_NULLS_LAST);
    }

    public CqnSortSpecification desc() {
        return SortSpecificationImpl.sort((CqnValue)this, CqnSortSpecification.Order.DESC);
    }

    public CqnSortSpecification descNullsFirst() {
        return SortSpecificationImpl.sort((CqnValue)this, CqnSortSpecification.Order.DESC_NULLS_FIRST);
    }

    public CqnSelectListValue as(String alias) {
        return SelectListValueBuilder.select((CqnValue)this).as(alias).build();
    }

    public CqnSelectListValue withoutAlias() {
        return SelectListValueBuilder.select((CqnValue)this).build();
    }

    public <U> Value<U> type(Class<U> javaType) {
        return this.type(CdsTypeUtils.cdsType(javaType).cdsName());
    }

    public Value<?> type(CdsBaseType cdsType) {
        return this.type(cdsType.cdsName());
    }

    public Value<?> type(String cdsType) {
        this.cdsType = cdsType;
        return this;
    }

    public Optional<String> type() {
        return Optional.ofNullable(this.cdsType);
    }

    public String toJson() {
        Jsonizer cqn = this.json();
        if (this.cdsType != null) {
            cqn.object("cast").put("type", this.cdsType);
        }
        return cqn.toJson();
    }

    protected abstract Jsonizer json();

    public String toString() {
        return this.toJson();
    }

    private static CqnValue value(Object t) {
        if (t == null) {
            return CqnNull.getInstance();
        }
        return t instanceof CqnValue ? (Literal<Object>)t : LiteralImpl.val(t);
    }
}

