/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.builder.model;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.sap.cds.impl.builder.model.AbstractPredicate;
import com.sap.cds.impl.parser.token.Jsonizer;
import com.sap.cds.ql.BooleanFunction;
import com.sap.cds.ql.cqn.CqnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class BooleanFunctionCall
extends AbstractPredicate
implements BooleanFunction {
    private final String functionName;
    private final List<CqnValue> args = new ArrayList<CqnValue>();

    protected BooleanFunctionCall(String functionName, List<? extends CqnValue> args) {
        this.functionName = functionName;
        this.args.clear();
        this.args.addAll(args);
    }

    public static BooleanFunctionCall create(String functionName, List<? extends CqnValue> args) {
        BooleanFunctionCall f = new BooleanFunctionCall(functionName, args);
        return f;
    }

    public static BooleanFunctionCall create(String functionName, CqnValue ... args) {
        return BooleanFunctionCall.create(functionName, Arrays.asList(args));
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public List<CqnValue> getArgs() {
        return Collections.unmodifiableList(this.args);
    }

    public BooleanFunctionCall args(CqnValue ... args) {
        return this.args(Arrays.asList(args));
    }

    private BooleanFunctionCall args(List<CqnValue> args) {
        this.args.clear();
        this.args.addAll(args);
        return this;
    }

    @Override
    public String toJson() {
        Jsonizer cqn = Jsonizer.object("func", this.functionName);
        if (!this.args.isEmpty()) {
            ArrayNode arg = cqn.array("args");
            this.args.forEach(arg_0 -> ((ArrayNode)arg).addPOJO(arg_0));
        }
        return cqn.toJson();
    }

    public String func() {
        return this.functionName;
    }

    public List<CqnValue> args() {
        return Collections.unmodifiableList(this.args);
    }
}

