/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.builder.model;

import com.sap.cds.impl.builder.model.AbstractPredicate;
import com.sap.cds.impl.builder.model.CqnTokenListBuilder;
import com.sap.cds.impl.parser.token.CqnBoolLiteral;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.cqn.CqnComparisonPredicate;
import com.sap.cds.ql.cqn.CqnLiteral;
import com.sap.cds.ql.cqn.CqnToken;
import com.sap.cds.ql.cqn.CqnValue;
import java.util.EnumMap;
import java.util.stream.Stream;

public class ComparisonPredicate
extends AbstractPredicate
implements CqnComparisonPredicate {
    private static EnumMap<CqnComparisonPredicate.Operator, CqnComparisonPredicate.Operator> REVERSE = new EnumMap(CqnComparisonPredicate.Operator.class);
    private final CqnValue lhs;
    private final CqnComparisonPredicate.Operator op;
    private final CqnValue rhs;

    private ComparisonPredicate(CqnValue lhs, CqnComparisonPredicate.Operator op, CqnValue rhs) {
        this.lhs = lhs;
        this.op = op;
        this.rhs = rhs;
    }

    public static Predicate eq(CqnValue lhs, CqnValue rhs) {
        return ComparisonPredicate.pred(lhs, CqnComparisonPredicate.Operator.EQ, rhs);
    }

    public static Predicate ne(CqnValue lhs, CqnValue rhs) {
        return ComparisonPredicate.pred(lhs, CqnComparisonPredicate.Operator.NE, rhs);
    }

    public static Predicate is(CqnValue lhs, CqnValue rhs) {
        return ComparisonPredicate.pred(lhs, CqnComparisonPredicate.Operator.IS, rhs);
    }

    public static Predicate isNot(CqnValue lhs, CqnValue rhs) {
        return ComparisonPredicate.pred(lhs, CqnComparisonPredicate.Operator.IS_NOT, rhs);
    }

    public static Predicate gt(CqnValue lhs, CqnValue rhs) {
        return ComparisonPredicate.pred(lhs, CqnComparisonPredicate.Operator.GT, rhs);
    }

    public static Predicate lt(CqnValue lhs, CqnValue rhs) {
        return ComparisonPredicate.pred(lhs, CqnComparisonPredicate.Operator.LT, rhs);
    }

    public static Predicate ge(CqnValue lhs, CqnValue rhs) {
        return ComparisonPredicate.pred(lhs, CqnComparisonPredicate.Operator.GE, rhs);
    }

    public static Predicate le(CqnValue lhs, CqnValue rhs) {
        return ComparisonPredicate.pred(lhs, CqnComparisonPredicate.Operator.LE, rhs);
    }

    public static Predicate pred(CqnValue lhs, CqnComparisonPredicate.Operator op, CqnValue rhs) {
        if (ComparisonPredicate.isComparableLiteral(lhs) && ComparisonPredicate.isComparableLiteral(rhs) && ComparisonPredicate.ofSameType(lhs, rhs)) {
            return ComparisonPredicate.evaluateComparablePredicate(lhs.asLiteral(), op, rhs.asLiteral());
        }
        return new ComparisonPredicate(lhs, op, rhs);
    }

    public CqnValue left() {
        return this.lhs;
    }

    public CqnValue right() {
        return this.rhs;
    }

    public CqnComparisonPredicate.Operator operator() {
        return this.op;
    }

    @Override
    public Predicate not() {
        return ComparisonPredicate.pred(this.lhs, REVERSE.get(this.op), this.rhs);
    }

    public Stream<CqnToken> tokens() {
        CqnTokenListBuilder tokens = new CqnTokenListBuilder();
        tokens.add(this.lhs);
        tokens.add(this.op.symbol);
        tokens.add(this.rhs);
        return tokens.stream();
    }

    private static boolean ofSameType(CqnValue v1, CqnValue v2) {
        return v1.asLiteral().value().getClass().equals(v2.asLiteral().value().getClass());
    }

    private static boolean isComparableLiteral(CqnValue val) {
        if (val.isLiteral()) {
            return val.asLiteral().value() instanceof Comparable;
        }
        return false;
    }

    private static Predicate evaluateComparablePredicate(CqnLiteral<?> lhs, CqnComparisonPredicate.Operator op, CqnLiteral<?> rhs) {
        Comparable lv = (Comparable)lhs.value();
        Object rv = rhs.value();
        switch (op) {
            case EQ: 
            case IS: {
                return CqnBoolLiteral.valueOf(lv.compareTo(rv) == 0);
            }
            case GT: {
                return CqnBoolLiteral.valueOf(lv.compareTo(rv) > 0);
            }
            case LT: {
                return CqnBoolLiteral.valueOf(lv.compareTo(rv) < 0);
            }
            case GE: {
                return CqnBoolLiteral.valueOf(lv.compareTo(rv) >= 0);
            }
            case LE: {
                return CqnBoolLiteral.valueOf(lv.compareTo(rv) <= 0);
            }
            case NE: 
            case IS_NOT: {
                return CqnBoolLiteral.valueOf(lv.compareTo(rv) != 0);
            }
        }
        return new ComparisonPredicate((CqnValue)lhs, op, (CqnValue)rhs);
    }

    static {
        REVERSE.put(CqnComparisonPredicate.Operator.EQ, CqnComparisonPredicate.Operator.NE);
        REVERSE.put(CqnComparisonPredicate.Operator.NE, CqnComparisonPredicate.Operator.EQ);
        REVERSE.put(CqnComparisonPredicate.Operator.GT, CqnComparisonPredicate.Operator.LE);
        REVERSE.put(CqnComparisonPredicate.Operator.LE, CqnComparisonPredicate.Operator.GT);
        REVERSE.put(CqnComparisonPredicate.Operator.LT, CqnComparisonPredicate.Operator.GE);
        REVERSE.put(CqnComparisonPredicate.Operator.GE, CqnComparisonPredicate.Operator.LT);
        REVERSE.put(CqnComparisonPredicate.Operator.IS, CqnComparisonPredicate.Operator.IS_NOT);
        REVERSE.put(CqnComparisonPredicate.Operator.IS_NOT, CqnComparisonPredicate.Operator.IS);
    }
}

