/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.builder.model;

import com.sap.cds.impl.builder.model.Connective;
import com.sap.cds.impl.builder.model.CqnTokenListBuilder;
import com.sap.cds.impl.builder.model.Disjunction;
import com.sap.cds.impl.parser.token.CqnBoolLiteral;
import com.sap.cds.impl.parser.token.CqnPlainImpl;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.cqn.CqnConnectivePredicate;
import com.sap.cds.ql.cqn.CqnExpression;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnToken;
import com.sap.cds.ql.cqn.CqnValue;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Conjunction
extends Connective {
    public Conjunction(List<? extends CqnPredicate> predicates) {
        super(CqnConnectivePredicate.Operator.AND, predicates);
    }

    public Conjunction(CqnPredicate p1, CqnPredicate p2) {
        super(CqnConnectivePredicate.Operator.AND, p1, p2);
    }

    @Override
    public Predicate and(CqnPredicate other, CqnPredicate ... more) {
        this.predicates.add(other);
        this.and(more);
        return this;
    }

    public Predicate and(CqnPredicate ... p) {
        this.predicates.addAll(Arrays.asList(p));
        return this;
    }

    @Override
    public Predicate not() {
        return this.negatedPredicates().collect(Disjunction._or());
    }

    public static CqnPredicate and(CqnPredicate p1, CqnPredicate p2) {
        if (p1 == CqnBoolLiteral.FALSE || p2 == CqnBoolLiteral.FALSE) {
            return CqnBoolLiteral.FALSE;
        }
        if (p1 == CqnBoolLiteral.TRUE) {
            return p2;
        }
        if (p2 == CqnBoolLiteral.TRUE) {
            return p1;
        }
        return new Conjunction(p1, p2);
    }

    public static Predicate and(Predicate p1, Predicate p2) {
        if (p1 == CqnBoolLiteral.FALSE || p2 == CqnBoolLiteral.FALSE) {
            return CqnBoolLiteral.FALSE;
        }
        if (p1 == CqnBoolLiteral.TRUE) {
            return p2;
        }
        if (p2 == CqnBoolLiteral.TRUE) {
            return p1;
        }
        return new Conjunction((CqnPredicate)p1, (CqnPredicate)p2);
    }

    public static Collector<CqnPredicate, ?, CqnPredicate> and() {
        return Collectors.reducing(CqnBoolLiteral.TRUE, Conjunction::and);
    }

    public static Collector<Predicate, ?, Predicate> _and() {
        return Collectors.reducing(CqnBoolLiteral.TRUE, Conjunction::and);
    }

    public static Optional<CqnPredicate> and(Optional<CqnPredicate> p1, Optional<CqnPredicate> p2) {
        CqnPredicate p = Conjunction.and(p1.orElse((CqnPredicate)CqnBoolLiteral.TRUE), p2.orElse((CqnPredicate)CqnBoolLiteral.TRUE));
        return p == CqnBoolLiteral.TRUE ? Optional.empty() : Optional.of(p);
    }

    @Override
    protected CqnToken identityToken() {
        return CqnBoolLiteral.TRUE;
    }

    @Override
    protected Stream<CqnToken> operatorTokens(CqnPredicate pred) {
        CqnTokenListBuilder tokenListBuilder = new CqnTokenListBuilder();
        if (pred instanceof Disjunction) {
            return tokenListBuilder.add((CqnValue)CqnPlainImpl.AND).add((CqnValue)CqnPlainImpl.LPAREN).add((CqnExpression)pred).add((CqnValue)CqnPlainImpl.RPAREN).stream();
        }
        return tokenListBuilder.add((CqnValue)CqnPlainImpl.AND).add((CqnExpression)pred).stream();
    }
}

