/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.builder.model;

import com.google.common.collect.Lists;
import com.sap.cds.impl.builder.model.AbstractPredicate;
import com.sap.cds.impl.builder.model.Conjunction;
import com.sap.cds.impl.builder.model.Disjunction;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.cqn.CqnConnectivePredicate;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnToken;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;

public abstract class Connective
extends AbstractPredicate
implements CqnConnectivePredicate {
    protected final List<CqnPredicate> predicates = new ArrayList<CqnPredicate>();
    private final CqnConnectivePredicate.Operator operator;

    public Connective(CqnConnectivePredicate.Operator operator, Iterable<? extends CqnPredicate> predicates) {
        this.operator = operator;
        for (CqnPredicate cqnPredicate : predicates) {
            this.predicates.add(cqnPredicate);
        }
    }

    protected Connective(CqnConnectivePredicate.Operator operator, CqnPredicate ... predicates) {
        this(operator, Arrays.asList(predicates));
    }

    public List<CqnPredicate> predicates() {
        return Collections.unmodifiableList(this.predicates);
    }

    Stream<Predicate> negatedPredicates() {
        return this.predicates.stream().map(p -> ((Predicate)p).not());
    }

    public CqnConnectivePredicate.Operator operator() {
        return this.operator;
    }

    public final Stream<CqnToken> tokens() {
        switch (this.predicates.size()) {
            case 0: {
                return Stream.of(this.identityToken());
            }
            case 1: {
                return this.predicates.get(0).tokens();
            }
        }
        return this.predicates.stream().flatMap(this::operatorTokens).skip(1L);
    }

    protected abstract CqnToken identityToken();

    protected abstract Stream<CqnToken> operatorTokens(CqnPredicate var1);

    public static Predicate create(CqnConnectivePredicate.Operator operator, List<? extends CqnPredicate> predicates) {
        if (operator == CqnConnectivePredicate.Operator.AND) {
            return (Predicate)predicates.stream().collect(Conjunction.and());
        }
        return (Predicate)predicates.stream().collect(Disjunction.or());
    }

    public static Predicate create(CqnConnectivePredicate.Operator operator, Iterable<? extends CqnPredicate> predicates) {
        return Connective.create(operator, Lists.newArrayList(predicates));
    }
}

