/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.builder.model;

import com.sap.cds.impl.builder.model.AbstractValue;
import com.sap.cds.impl.parser.PathParser;
import com.sap.cds.impl.parser.token.Jsonizer;
import com.sap.cds.impl.parser.token.RefSegmentImpl;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.RefSegment;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnSyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

public class ElementRefImpl<T>
extends AbstractValue<T>
implements ElementRef<T> {
    private final LinkedList<RefSegment> segments = new LinkedList();
    private String alias = null;

    private ElementRefImpl(List<RefSegment> segments) {
        if (segments.isEmpty()) {
            throw new CqnSyntaxException("Reference segments must not be empty");
        }
        this.segments.addAll(segments);
    }

    public static <T> ElementRef<T> elementRef(CqnReference ref) {
        List<RefSegment> segments = RefSegmentImpl.copy(ref.segments());
        ElementRefImpl<T> elementRef = new ElementRefImpl<T>(segments);
        ref.alias().ifPresent(elementRef::as);
        return elementRef;
    }

    public static <T> ElementRef<T> element(CqnStructuredTypeRef parent, String path) {
        List<RefSegment> segments = RefSegmentImpl.copy(parent.segments());
        segments.addAll(PathParser.segments(path));
        return new ElementRefImpl<T>(segments);
    }

    public static <T> ElementRef<T> parse(String p) {
        String path = p.replace('}', ' ').trim();
        ElementRef<T> ref = ElementRefImpl.element(PathParser.segments(path));
        if (path.contains("{")) {
            ref.as(PathParser.displayName(path));
        }
        return ref;
    }

    public static <T> ElementRef<T> key() {
        return ElementRefImpl.element("$key");
    }

    public static <T> ElementRef<T> element(String ... path) {
        return ElementRefImpl.element(PathParser.segments(path));
    }

    public static ElementRef<Object> element(List<? extends CqnReference.Segment> prefix, CqnElementRef ref) {
        List suffix = ref.segments();
        ArrayList<? extends CqnReference.Segment> segments = new ArrayList<CqnReference.Segment>(prefix.size() + suffix.size());
        segments.addAll(prefix);
        segments.addAll(suffix);
        return ElementRefImpl.element(segments);
    }

    public static ElementRef<Object> subRef(CqnElementRef ref, int startIndex) {
        List suffix = ref.segments();
        return ElementRefImpl.element(suffix.subList(startIndex, suffix.size()));
    }

    public static <T> ElementRef<T> element(List<? extends CqnReference.Segment> segments) {
        return new ElementRefImpl<T>(segments);
    }

    public List<RefSegment> segments() {
        return Collections.unmodifiableList(this.segments);
    }

    public String displayName() {
        return this.alias().orElse(this.lastSegment());
    }

    public ElementRef<T> as(String alias) {
        this.alias = alias;
        return this;
    }

    public Optional<String> alias() {
        return Optional.ofNullable(this.alias);
    }

    @Override
    protected Jsonizer json() {
        Jsonizer cqn = Jsonizer.object("ref", this.segments);
        this.alias().ifPresent(a -> cqn.put("as", a));
        return cqn;
    }
}

