/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.builder.model;

import com.sap.cds.JSONizable;
import com.sap.cds.impl.builder.model.ElementRefImpl;
import com.sap.cds.impl.builder.model.SelectList;
import com.sap.cds.impl.builder.model.StructuredTypeImpl;
import com.sap.cds.impl.builder.model.StructuredTypeRefImpl;
import com.sap.cds.impl.parser.builder.LimitImpl;
import com.sap.cds.impl.parser.token.Jsonizer;
import com.sap.cds.ql.Expand;
import com.sap.cds.ql.Selectable;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.cqn.CqnLimit;
import com.sap.cds.ql.cqn.CqnSortSpecification;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnToken;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ExpandBuilder<T extends StructuredType<T>>
extends SelectList
implements Expand<T> {
    private final List<CqnSortSpecification> orderBy = new ArrayList<CqnSortSpecification>();
    private final T typeRef;
    private boolean lazy;
    private long top = -1L;
    private long skip = 0L;

    private ExpandBuilder(T typeRef, boolean lazy) {
        super(StructuredTypeRefImpl.typeRef(typeRef), SelectList.Type.EXPAND);
        this.typeRef = typeRef;
        this.lazy = lazy;
    }

    public static ExpandBuilder<StructuredTypeImpl> expand(CqnStructuredTypeRef ref) {
        return new ExpandBuilder<StructuredTypeImpl>(StructuredTypeImpl.structuredType(ref), false);
    }

    public static <T extends StructuredType<T>> ExpandBuilder<T> expand(T entity) {
        return ExpandBuilder.expand(entity, false);
    }

    public static <T extends StructuredType<T>> ExpandBuilder<T> expand(T entity, boolean lazy) {
        return new ExpandBuilder<T>(entity, lazy);
    }

    @Override
    public ExpandBuilder<T> all() {
        super.all();
        return this;
    }

    @Override
    public ExpandBuilder<T> items(Selectable item) {
        super.items(item);
        return this;
    }

    @Override
    public ExpandBuilder<T> items(Iterable<? extends Selectable> items) {
        super.items(items);
        return this;
    }

    public Expand<T> limit(long top, long skip) {
        this.top = top;
        this.skip = skip;
        return this;
    }

    @Deprecated
    public Optional<CqnLimit> limit() {
        if (this.hasLimit()) {
            return Optional.of(LimitImpl.create(this.top, this.skip));
        }
        return Optional.empty();
    }

    public long top() {
        return this.top;
    }

    public long skip() {
        return this.skip;
    }

    public Expand<T> orderBy(List<CqnSortSpecification> sortSpec) {
        this.orderBy.clear();
        this.orderBy.addAll(sortSpec);
        return this;
    }

    public Expand<T> orderBy(String ... refs) {
        this.orderBy.clear();
        for (String ref : refs) {
            this.orderBy.add(ElementRefImpl.parse(ref).asc());
        }
        return this;
    }

    public List<CqnSortSpecification> orderBy() {
        return Collections.unmodifiableList(this.orderBy);
    }

    public String displayName() {
        return this.alias().orElse(this.ref().lastSegment());
    }

    public ExpandBuilder<T> as(String alias) {
        this.ref().as(alias);
        return this;
    }

    public Optional<String> alias() {
        return this.ref().alias();
    }

    public CqnToken token() {
        return this;
    }

    public boolean lazy() {
        return this.lazy;
    }

    public void lazy(boolean l) {
        this.lazy = l;
    }

    public String toJson() {
        Jsonizer cqn = Jsonizer.object((JSONizable)this.ref());
        cqn.put(this.type().toString(), this.items());
        if (this.hasLimit()) {
            cqn.put("limit", LimitImpl.create(this.top, this.skip));
        }
        if (!this.orderBy.isEmpty()) {
            cqn.put("orderBy", this.orderBy);
        }
        return cqn.toJson();
    }

    public Expand<T> orderBy(Function<T, CqnSortSpecification> sort) {
        return this.orderBy(this.list(sort));
    }

    public Expand<T> orderBy(Function<T, CqnSortSpecification> sort1, Function<T, CqnSortSpecification> sort2) {
        return this.orderBy(this.list(sort1, sort2));
    }

    public Expand<T> orderBy(Function<T, CqnSortSpecification> sort1, Function<T, CqnSortSpecification> sort2, Function<T, CqnSortSpecification> sort3) {
        return this.orderBy(this.list(sort1, sort2, sort3));
    }

    public Expand<T> orderBy(Function<T, CqnSortSpecification> sort1, Function<T, CqnSortSpecification> sort2, Function<T, CqnSortSpecification> sort3, Function<T, CqnSortSpecification> sort4) {
        return this.orderBy(this.list(sort1, sort2, sort3, sort4));
    }

    public Expand<T> orderBy(Function<T, CqnSortSpecification> sort1, Function<T, CqnSortSpecification> sort2, Function<T, CqnSortSpecification> sort3, Function<T, CqnSortSpecification> sort4, Function<T, CqnSortSpecification> sort5) {
        return this.orderBy(this.list(sort1, sort2, sort3, sort4, sort5));
    }

    public Expand<T> orderBy(Function<T, CqnSortSpecification> ... sortSpec) {
        return this.orderBy(this.list(sortSpec));
    }

    @SafeVarargs
    private final <R> List<R> list(Function<T, R> ... functions) {
        return Arrays.stream(functions).map(f -> f.apply(this.typeRef.getType())).collect(Collectors.toList());
    }
}

