/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.builder.model;

import com.sap.cds.impl.builder.model.AbstractPredicate;
import com.sap.cds.impl.builder.model.Conjunction;
import com.sap.cds.impl.parser.token.Jsonizer;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.RefSegment;
import com.sap.cds.ql.StructuredTypeRef;
import com.sap.cds.ql.cqn.CqnMatchPredicate;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnToken;
import com.sap.cds.ql.cqn.Modifier;
import com.sap.cds.ql.impl.ExpressionVisitor;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;

public class MatchPredicate
extends AbstractPredicate
implements CqnMatchPredicate {
    private final CqnStructuredTypeRef ref;
    private final CqnMatchPredicate.Quantifier quantifier;
    private final CqnPredicate predicate;

    private MatchPredicate(CqnStructuredTypeRef ref, CqnMatchPredicate.Quantifier quantifier, CqnPredicate predicate) {
        this.ref = ref;
        this.quantifier = quantifier;
        this.predicate = predicate;
    }

    public static MatchPredicate all(CqnStructuredTypeRef ref, CqnPredicate predicate) {
        return new MatchPredicate(ref, CqnMatchPredicate.Quantifier.ALL, predicate);
    }

    public static MatchPredicate any(CqnStructuredTypeRef ref, CqnPredicate predicate) {
        return new MatchPredicate(ref, CqnMatchPredicate.Quantifier.ANY, predicate);
    }

    public static MatchPredicate match(CqnStructuredTypeRef ref, CqnMatchPredicate.Quantifier quantifier, CqnPredicate predicate) {
        return new MatchPredicate(ref, quantifier, predicate);
    }

    public Stream<CqnToken> tokens() {
        return Stream.of(this);
    }

    private StructuredTypeRef filteredRef() {
        Modifier m = new Modifier(){

            public CqnStructuredTypeRef ref(StructuredTypeRef ref) {
                Optional refFilter = ref.targetSegment().filter();
                Optional<CqnPredicate> pred = Optional.ofNullable(MatchPredicate.this.predicate).map(p -> MatchPredicate.this.quantifier == CqnMatchPredicate.Quantifier.ALL ? CQL.not((CqnPredicate)p) : p);
                Conjunction.and(refFilter, pred).ifPresent(arg_0 -> ((RefSegment)ref.targetSegment()).filter(arg_0));
                return ref;
            }
        };
        return ExpressionVisitor.copy(this.ref, m);
    }

    public CqnStructuredTypeRef ref() {
        return this.ref;
    }

    public CqnMatchPredicate.Quantifier quantifier() {
        return this.quantifier;
    }

    public Optional<CqnPredicate> predicate() {
        return Optional.ofNullable(this.predicate);
    }

    @Override
    public String toJson() {
        if (this.quantifier == CqnMatchPredicate.Quantifier.ANY) {
            return Jsonizer.object("xpr", Arrays.asList("EXISTS", this.filteredRef())).toJson();
        }
        return Jsonizer.object("xpr", Arrays.asList("NOT", "EXISTS", this.filteredRef())).toJson();
    }
}

