/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.builder.model;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.sap.cds.impl.builder.model.AbstractValue;
import com.sap.cds.impl.parser.token.Jsonizer;
import com.sap.cds.ql.FunctionCall;
import com.sap.cds.ql.cqn.CqnToken;
import com.sap.cds.ql.cqn.CqnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;

public class ScalarFunctionCall<T>
extends AbstractValue<T>
implements FunctionCall<T> {
    private final String functionName;
    private final List<CqnValue> args = new ArrayList<CqnValue>();

    private ScalarFunctionCall(String functionName) {
        this.functionName = functionName;
    }

    public static <T> FunctionCall<T> create(String functionName, Class<T> t, CqnValue ... args) {
        return ScalarFunctionCall.create(functionName, args);
    }

    public static <T> FunctionCall<T> create(String functionName, CqnValue ... args) {
        ScalarFunctionCall<T> f = new ScalarFunctionCall<T>(functionName);
        f.args(args);
        return f;
    }

    public static <T> FunctionCall<T> create(String functionName, Iterable<? extends CqnValue> args) {
        ScalarFunctionCall<T> f = new ScalarFunctionCall<T>(functionName);
        super.args(args);
        return f;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public List<CqnValue> getArgs() {
        return Collections.unmodifiableList(this.args);
    }

    public FunctionCall<T> args(CqnValue ... args) {
        return this.args(Arrays.asList(args));
    }

    private FunctionCall<T> args(Iterable<? extends CqnValue> args) {
        this.args.clear();
        args.forEach(this.args::add);
        return this;
    }

    public Stream<CqnToken> tokens() {
        return Stream.of(this);
    }

    @Override
    protected Jsonizer json() {
        Jsonizer cqn = Jsonizer.object("func", this.functionName);
        if (!this.args.isEmpty()) {
            ArrayNode arg = cqn.array("args");
            this.args.forEach(arg_0 -> ((ArrayNode)arg).addPOJO(arg_0));
        }
        return cqn;
    }

    public String func() {
        return this.functionName;
    }

    public List<CqnValue> args() {
        return Collections.unmodifiableList(this.args);
    }
}

