/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.builder.model;

import com.sap.cds.impl.builder.model.ExpandBuilder;
import com.sap.cds.impl.builder.model.InlineBuilder;
import com.sap.cds.impl.builder.model.StructuredTypeRefImpl;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Selectable;
import com.sap.cds.ql.StructuredTypeRef;
import com.sap.cds.ql.cqn.CqnSelectList;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.impl.SelectListValueBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public abstract class SelectList
implements CqnSelectList {
    private final StructuredTypeRef ref;
    private final List<CqnSelectListItem> items = new ArrayList<CqnSelectListItem>();
    private final Map<String, String> elementMapping = new HashMap<String, String>();
    private final Type type;

    SelectList(StructuredTypeRef ref, Type type) {
        this.ref = type == Type.EXPAND && ref.segments().isEmpty() ? StructuredTypeRefImpl.typeRef("*") : ref;
        this.type = type;
    }

    public static SelectList create(StructuredTypeRef ref, Type type) {
        if (type == Type.INLINE) {
            return InlineBuilder.inline(ref);
        }
        return ExpandBuilder.expand(ref);
    }

    public Type type() {
        return this.type;
    }

    public StructuredTypeRef ref() {
        return this.ref;
    }

    public List<CqnSelectListItem> items() {
        return Collections.unmodifiableList(this.items);
    }

    public SelectList all() {
        this.items.clear();
        this.items.add((CqnSelectListItem)CQL.star());
        return this;
    }

    public SelectList items(Selectable item) {
        this.items.add(SelectListValueBuilder.refToSlv(item));
        return this;
    }

    public SelectList items(Iterable<? extends Selectable> items) {
        this.items.clear();
        items.forEach(this::items);
        return this;
    }

    public boolean isInline() {
        return this.type == Type.INLINE;
    }

    public boolean isExpand() {
        return this.type == Type.EXPAND;
    }

    public String toString() {
        return this.toJson();
    }

    public void setElementMapping(Map<String, String> mapping) {
        this.elementMapping.putAll(mapping);
    }

    public Map<String, String> getElementMapping() {
        return this.elementMapping;
    }

    public static enum Type {
        INLINE,
        EXPAND;


        public String toString() {
            return this.name().toLowerCase(Locale.US);
        }
    }
}

