/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.builder.model;

import com.google.common.annotations.Beta;
import com.sap.cds.impl.builder.model.ElementRefImpl;
import com.sap.cds.impl.builder.model.ExistsSubquery;
import com.sap.cds.impl.builder.model.ExpandBuilder;
import com.sap.cds.impl.builder.model.ExpressionImpl;
import com.sap.cds.impl.builder.model.InlineBuilder;
import com.sap.cds.impl.builder.model.MatchPredicate;
import com.sap.cds.impl.builder.model.SelectList;
import com.sap.cds.impl.builder.model.StructuredTypeProxy;
import com.sap.cds.impl.builder.model.StructuredTypeRefImpl;
import com.sap.cds.impl.parser.PathParser;
import com.sap.cds.impl.parser.token.RefSegmentImpl;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.Expand;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.RefSegment;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.Selectable;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.StructuredTypeRef;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnVisitor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class StructuredTypeImpl
implements StructuredType<StructuredTypeImpl> {
    private final StructuredTypeRef ref;
    private final boolean relative;
    private static final StructuredTypeImpl BUILDER = new StructuredTypeImpl(StructuredTypeRefImpl.typeRef(Collections.emptyList()), false);

    private StructuredTypeImpl(StructuredTypeRef ref, boolean relative) {
        this.ref = ref;
        this.relative = relative;
    }

    public static StructuredTypeImpl builder() {
        return BUILDER;
    }

    public static StructuredTypeImpl structuredType(String entityName) {
        return new StructuredTypeImpl(StructuredTypeRefImpl.typeRef(entityName), false);
    }

    public static StructuredTypeImpl structuredType(CqnStructuredTypeRef ref) {
        StructuredTypeRef struct = StructuredTypeRefImpl.typeRef(ref.segments());
        ref.alias().ifPresent(alias -> struct.as(alias));
        return new StructuredTypeImpl(struct, true);
    }

    public static StructuredTypeImpl structuredType(StructuredTypeRef ref) {
        return new StructuredTypeImpl(ref, true);
    }

    public StructuredType<StructuredTypeImpl> as(String alias) {
        this.ref.as(alias);
        return this;
    }

    public final <E> ElementRef<E> get(String path) {
        if (this.relative) {
            return ElementRefImpl.element((CqnStructuredTypeRef)this.ref, path);
        }
        return ElementRefImpl.parse(path);
    }

    public final <E> ElementRef<E> get(String path, Class<E> type) {
        return this.get(path);
    }

    public <T extends StructuredType<T>> T to(String path, Class<T> type) {
        return StructuredTypeProxy.create(this.to(path), type);
    }

    public StructuredTypeImpl to(String path) {
        return this.to(PathParser.segments(path));
    }

    private StructuredTypeImpl to(Iterable<? extends CqnReference.Segment> path) {
        List<RefSegment> segments = RefSegmentImpl.copy(this.ref.segments());
        path.forEach(seg -> segments.add(RefSegmentImpl.copy(seg)));
        return new StructuredTypeImpl(StructuredTypeRefImpl.typeRef(segments), true);
    }

    public final StructuredTypeImpl filter(CqnPredicate pred) {
        ((RefSegment)this.ref.segments().get(this.ref.segments().size() - 1)).filter(pred);
        return this;
    }

    public final StructuredTypeImpl filter(Function<StructuredTypeImpl, CqnPredicate> p) {
        return this.filter(p.apply(this.getType()));
    }

    public StructuredTypeImpl filterByParams(Collection<String> parameters) {
        return this.filter((CqnPredicate)ExpressionImpl.byParams(parameters));
    }

    public StructuredTypeImpl matching(Map<String, ?> values) {
        return this.filter((CqnPredicate)ExpressionImpl.matching(values));
    }

    @Beta
    public final Expand<StructuredTypeImpl> lazy() {
        return ExpandBuilder.expand(this, true).all();
    }

    public final Expand<StructuredTypeImpl> expand() {
        return ExpandBuilder.expand(this).all();
    }

    public final Expand<StructuredTypeImpl> expand(List<Function<StructuredTypeImpl, ? extends Selectable>> items) {
        List slis = items.stream().map(f -> (Selectable)f.apply(this.getType())).collect(Collectors.toList());
        return this.expand(slis);
    }

    public final Expand<StructuredTypeImpl> expand(String ... refs) {
        List slis = Arrays.stream(refs).map(ElementRefImpl::parse).collect(Collectors.toList());
        return this.expand(slis);
    }

    public Expand<StructuredTypeImpl> expand(Selectable ... items) {
        return this.expand((Iterable<? extends Selectable>)Arrays.asList(items));
    }

    public Expand<StructuredTypeImpl> expand(Iterable<? extends Selectable> items) {
        return ExpandBuilder.expand(this).items(items);
    }

    public final SelectList inline() {
        return InlineBuilder.inline(this.ref).all();
    }

    public final SelectList inline(List<Function<StructuredTypeImpl, ? extends Selectable>> items) {
        List slis = items.stream().map(f -> (Selectable)f.apply(this.getType())).collect(Collectors.toList());
        return this.inline((Iterable<? extends Selectable>)slis);
    }

    public final SelectList inline(String ... refs) {
        List slis = Arrays.stream(refs).map(ElementRefImpl::parse).collect(Collectors.toList());
        return this.inline((Iterable<? extends Selectable>)slis);
    }

    public SelectList inline(Selectable ... items) {
        return this.inline((Iterable<? extends Selectable>)Arrays.asList(items));
    }

    public SelectList inline(Iterable<? extends Selectable> items) {
        return InlineBuilder.inline(this.ref).items(items);
    }

    public final StructuredTypeImpl getType() {
        return BUILDER;
    }

    public final CqnSelectListItem _all() {
        return CQL.star();
    }

    public void accept(CqnVisitor visitor) {
        this.ref.accept(visitor);
    }

    public String toJson() {
        return this.ref.toJson();
    }

    public String toString() {
        return this.toJson();
    }

    public boolean isRef() {
        return true;
    }

    public StructuredTypeRef asRef() {
        return this.ref;
    }

    public Predicate exists(Function<StructuredTypeImpl, Select<?>> query) {
        StructuredTypeImpl outer = this.getType().to("$outer");
        Select<?> subQuery = query.apply(outer);
        return new ExistsSubquery((CqnSelect)subQuery);
    }

    public Predicate anyMatch(Function<StructuredTypeImpl, CqnPredicate> p) {
        return this.anyMatch(p.apply(this.getType()));
    }

    public Predicate anyMatch(CqnPredicate p) {
        return MatchPredicate.any((CqnStructuredTypeRef)this.asRef(), p);
    }

    public Predicate exists() {
        return this.anyMatch((CqnPredicate)null);
    }

    public Predicate allMatch(Function<StructuredTypeImpl, CqnPredicate> p) {
        return this.allMatch(p.apply(this.getType()));
    }

    public Predicate allMatch(CqnPredicate p) {
        return MatchPredicate.all((CqnStructuredTypeRef)this.asRef(), p);
    }
}

