/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.parser;

import com.sap.cds.impl.builder.model.ArithmeticExpr;
import com.sap.cds.impl.builder.model.ArithmeticNegation;
import com.sap.cds.impl.builder.model.BetweenPredicate;
import com.sap.cds.impl.builder.model.ComparisonPredicate;
import com.sap.cds.impl.builder.model.CqnNull;
import com.sap.cds.impl.builder.model.ExistsSubquery;
import com.sap.cds.impl.builder.model.InPredicate;
import com.sap.cds.impl.builder.model.MatchPredicate;
import com.sap.cds.impl.builder.model.StructuredTypeRefImpl;
import com.sap.cds.impl.parser.AbstractCqnExpressionParser;
import com.sap.cds.impl.parser.builder.ExpressionBuilder;
import com.sap.cds.impl.parser.token.RefSegmentImpl;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.RefSegment;
import com.sap.cds.ql.StructuredTypeRef;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.CqnComparisonPredicate;
import com.sap.cds.ql.cqn.CqnListValue;
import com.sap.cds.ql.cqn.CqnPlain;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnSyntaxException;
import com.sap.cds.ql.cqn.CqnToken;
import com.sap.cds.ql.cqn.CqnValue;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ExprParser
extends AbstractCqnExpressionParser {
    public CqnValue parseValue(Stream<CqnToken> tokens) {
        return this.parseValue(tokens.collect(Collectors.toList()));
    }

    public CqnValue parseValue(List<CqnToken> tokenList) {
        if (tokenList.isEmpty()) {
            return null;
        }
        this.tokens = new LinkedList<CqnToken>(tokenList);
        this.aheadToken = (CqnToken)this.tokens.getFirst();
        this.pos = 0;
        CqnValue value = this.value();
        if (this.aheadToken != null) {
            throw this.unexpected();
        }
        return value;
    }

    private CqnValue value() {
        return this.valueExpression();
    }

    private CqnValue valueExpression() {
        Value<Number> expr = this.valueTerm();
        while (this.peek("+", "-")) {
            if (this.is("+")) {
                expr = ArithmeticExpr.plus((CqnValue)expr, this.valueTerm());
                continue;
            }
            if (!this.is("-")) continue;
            expr = ArithmeticExpr.minus(expr, this.valueTerm());
        }
        return expr;
    }

    private CqnValue valueTerm() {
        Value<Number> term = this.valueFactor();
        while (this.peek("*", "/")) {
            if (this.is("*")) {
                term = ArithmeticExpr.times((CqnValue)term, this.valueFactor());
                continue;
            }
            if (!this.is("/")) continue;
            term = ArithmeticExpr.dividedBy(term, this.valueFactor());
        }
        return term;
    }

    private CqnValue valueFactor() {
        if (this.is("+")) {
            // empty if block
        }
        if (this.is("-")) {
            CqnValue val = this.valueFactor();
            return ArithmeticNegation.negate(val);
        }
        return this.valuePrimary();
    }

    private CqnValue valuePrimary() {
        if (this.isXpr()) {
            CqnValue expr = new ExprParser().parseValue(this.getXpr().xpr());
            return expr;
        }
        if (this.is("(")) {
            CqnValue expr = this.valueExpression();
            this.expect(")");
            return expr;
        }
        return this.getValue();
    }

    @Override
    protected CqnPredicate predicate() {
        if (this.isPredicate()) {
            return this.getPredicate();
        }
        if (this.is("exists")) {
            return this.exists();
        }
        CqnValue value = this.value();
        CqnPlain plain = this.getPlain();
        switch (plain.plain().toLowerCase(Locale.US)) {
            case "=": {
                return this.comparison(value, CqnComparisonPredicate.Operator.EQ);
            }
            case ">": {
                return this.comparison(value, CqnComparisonPredicate.Operator.GT);
            }
            case "<": {
                return this.comparison(value, CqnComparisonPredicate.Operator.LT);
            }
            case ">=": {
                return this.comparison(value, CqnComparisonPredicate.Operator.GE);
            }
            case "<=": {
                return this.comparison(value, CqnComparisonPredicate.Operator.LE);
            }
            case "<>": {
                return this.comparison(value, CqnComparisonPredicate.Operator.NE);
            }
            case "is": {
                return this.isNullOrValue(value, CqnComparisonPredicate.Operator.IS);
            }
            case "in": {
                return this.in(value);
            }
            case "between": {
                return this.between(value);
            }
        }
        ArrayList<CqnToken> tokens = new ArrayList<CqnToken>();
        tokens.add((CqnToken)value);
        tokens.add((CqnToken)plain);
        while (this.hasNext() && !this.peek("and") && !this.peek("or") && !this.peek(")")) {
            tokens.add(this.aheadToken);
            this.nextToken();
        }
        return ExpressionBuilder.create(tokens).predicate();
    }

    private CqnPredicate exists() {
        if (this.isRef()) {
            CqnReference ref = this.get(CqnReference.class);
            int n = ref.segments().size();
            ArrayList<RefSegment> segments = new ArrayList<RefSegment>(ref.segments().subList(0, n - 1));
            segments.add(RefSegmentImpl.refSegment(ref.lastSegment()));
            StructuredTypeRef typeRef = StructuredTypeRefImpl.typeRef(segments);
            CqnPredicate predicate = ref.targetSegment().filter().orElse(null);
            return MatchPredicate.any((CqnStructuredTypeRef)typeRef, predicate);
        }
        return new ExistsSubquery(this.getSelect());
    }

    private CqnSelect getSelect() {
        return this.get(CqnSelect.class);
    }

    private CqnPredicate isNullOrValue(CqnValue value, CqnComparisonPredicate.Operator is) {
        Object rhs;
        boolean negate = false;
        if (this.is("not")) {
            negate = true;
        }
        if (this.isPlain()) {
            this.expect("null");
            rhs = CqnNull.getInstance();
        } else {
            rhs = this.getValue();
        }
        Predicate pred = ComparisonPredicate.pred(value, CqnComparisonPredicate.Operator.IS, rhs);
        if (negate) {
            pred = pred.not();
        }
        return pred;
    }

    private CqnPredicate between(CqnValue value) {
        CqnValue low = this.getValue();
        this.expect("and");
        CqnValue high = this.getValue();
        return BetweenPredicate.between(value, low, high);
    }

    private CqnPredicate in(CqnValue value) {
        if (this.isList()) {
            CqnListValue list = this.getList();
            return InPredicate.in(value, list.values());
        }
        if (this.isRef()) {
            return InPredicate.in(value, this.getValue());
        }
        if (this.isXpr() && this.aheadToken.tokens().count() == 1L) {
            return InPredicate.in(value, Stream.of(this.value()));
        }
        this.expect("(");
        ArrayList<CqnValue> vs = new ArrayList<CqnValue>();
        vs.add(this.getValue());
        while (this.is(",")) {
            vs.add(this.getValue());
        }
        if (!this.is(")")) {
            throw new CqnSyntaxException("Missing closing parenthesis");
        }
        return InPredicate.in(value, vs.stream());
    }

    private CqnPredicate comparison(CqnValue lhs, CqnComparisonPredicate.Operator op) {
        return ComparisonPredicate.pred(lhs, op, this.value());
    }
}

