/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.parser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.sap.cds.CdsDataStoreException;
import com.sap.cds.ql.CdsDataException;
import com.sap.cds.ql.cqn.CqnSyntaxException;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Map;

public class JsonParser {
    private static final ObjectMapper mapper = new ObjectMapper().enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES}).enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_SINGLE_QUOTES});
    static final TypeReference<List<Map<String, Object>>> LIST_OF_MAPS = new TypeReference<List<Map<String, Object>>>(){};
    static final TypeReference<Map<String, Object>> MAP = new TypeReference<Map<String, Object>>(){};

    private JsonParser() {
    }

    public static Map<String, Object> map(JsonNode node) {
        return (Map)mapper.convertValue((Object)node, MAP);
    }

    public static List<Map<String, Object>> list(ArrayNode array) {
        return (List)mapper.convertValue((Object)array, LIST_OF_MAPS);
    }

    public static <T extends JsonNode> T parseJson(String json) {
        try {
            return (T)mapper.readTree(json);
        }
        catch (JsonProcessingException e) {
            throw new CqnSyntaxException("Invalid JSON: " + json, (Throwable)e);
        }
    }

    public static Object map(Reader reader) {
        try {
            return mapper.readValue(reader, MAP);
        }
        catch (JsonProcessingException e) {
            throw new CdsDataException("failed to deserialize J object", (Throwable)e);
        }
        catch (IOException e) {
            throw new CdsDataStoreException("failed to read input stream", (Throwable)e);
        }
    }
}

