/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.parser;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.google.common.collect.Lists;
import com.sap.cds.impl.builder.model.ExpandBuilder;
import com.sap.cds.impl.builder.model.LockImpl;
import com.sap.cds.impl.builder.model.SelectList;
import com.sap.cds.impl.builder.model.StructuredTypeImpl;
import com.sap.cds.impl.parser.ExpressionParser;
import com.sap.cds.impl.parser.JsonParser;
import com.sap.cds.impl.parser.TokenParser;
import com.sap.cds.impl.parser.builder.SortSpecificationImpl;
import com.sap.cds.impl.parser.search.SearchParser;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.Selectable;
import com.sap.cds.ql.StructuredTypeRef;
import com.sap.cds.ql.cqn.CqnLock;
import com.sap.cds.ql.cqn.CqnNumericLiteral;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnSelectListValue;
import com.sap.cds.ql.cqn.CqnSortSpecification;
import com.sap.cds.ql.cqn.CqnSource;
import com.sap.cds.ql.cqn.CqnSyntaxException;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.impl.SelectBuilder;
import com.sap.cds.ql.impl.SelectListValueBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class SelectParser {
    private static final String FOR_UPDATE = CqnLock.Mode.EXCLUSIVE.csn();
    private static final String FOR_SHARE_LOCK = CqnLock.Mode.SHARED.csn();
    private final JsonNode selectNode;

    private SelectParser(String cqn) {
        this.selectNode = JsonParser.parseJson(cqn).get("SELECT");
    }

    public static SelectParser of(String cqn) {
        return new SelectParser(cqn);
    }

    public static Select<StructuredTypeImpl> parse(String cqn) {
        return SelectParser.of(cqn).parse();
    }

    public Select<StructuredTypeImpl> parse() {
        SelectBuilder<StructuredTypeImpl> select = SelectBuilder.from(this.from());
        select.distinct(this.distinct());
        select.count(this.count());
        select.columns(this.columns());
        select.excluding(this.excluding());
        select.where(this.where());
        select.search(this.search());
        select.orderBy((List)this.orderBy());
        this.limit(this.selectNode).ifPresent(l -> select.limit(l.top, l.skip));
        select.having(this.having());
        select.groupBy((List)this.groupBy());
        select.lockSelectedRows(this.lock());
        return select;
    }

    protected CqnSource from() {
        return TokenParser.source(this.selectNode.get("from"));
    }

    private List<CqnValue> groupBy() {
        ArrayNode arrayNode = (ArrayNode)this.selectNode.withArray("groupBy");
        ArrayList tokens = Lists.newArrayList();
        for (JsonNode node : arrayNode) {
            tokens.add(TokenParser.parseValue(node));
        }
        return tokens;
    }

    private Optional<Limit> limit(JsonNode node) {
        if (!node.has("limit")) {
            return Optional.empty();
        }
        JsonNode limitNode = node.get("limit");
        if (!limitNode.has("rows")) {
            throw new CqnSyntaxException("Unsupported limit syntax, 'rows' is mandatory");
        }
        Limit limit = new Limit();
        CqnNumericLiteral rows = (CqnNumericLiteral)TokenParser.parseValue(limitNode.get("rows"));
        limit.top = rows.value().longValue();
        if (limitNode.has("offset")) {
            CqnNumericLiteral offset = (CqnNumericLiteral)TokenParser.parseValue(limitNode.get("offset"));
            limit.skip = offset.value().longValue();
        }
        return Optional.of(limit);
    }

    private boolean distinct() {
        return this.readBoolean("distinct");
    }

    private boolean count() {
        return this.readBoolean("count");
    }

    private boolean readBoolean(String fieldName) {
        JsonNode node = this.selectNode.get(fieldName);
        try {
            if (node == null) {
                return false;
            }
            return node.asBoolean();
        }
        catch (IllegalArgumentException e) {
            throw new CqnSyntaxException("Unsupported syntax for Boolean value'" + node.toString() + "'", (Throwable)e);
        }
    }

    private List<CqnSortSpecification> orderBy() {
        return SelectParser.orderBy((ArrayNode)this.selectNode.withArray("orderBy"));
    }

    private static List<CqnSortSpecification> orderBy(ArrayNode arrayNode) {
        ArrayList<CqnSortSpecification> orderBy = new ArrayList<CqnSortSpecification>();
        for (JsonNode node : arrayNode) {
            Object value = TokenParser.parseValue(node);
            String sort = node.has("sort") ? node.get("sort").asText() : null;
            String nulls = node.has("nulls") ? node.get("nulls").asText() : null;
            orderBy.add(SortSpecificationImpl.sort(value, CqnSortSpecification.Order.valueOf((String)sort, (String)nulls)));
        }
        return orderBy;
    }

    private Stream<CqnSelectListItem> columns() {
        ArrayNode cols = (ArrayNode)this.selectNode.withArray("columns");
        return StreamSupport.stream(cols.spliterator(), false).map(this::createSelectListItem);
    }

    private CqnSelectListItem createSelectListItem(JsonNode node) {
        if (node.has("ref")) {
            if (node.has("inline")) {
                return this.createSelectList(SelectList.Type.INLINE, node);
            }
            if (node.has("expand")) {
                return this.createSelectList(SelectList.Type.EXPAND, node);
            }
        }
        if (node.getNodeType() == JsonNodeType.STRING && "*".equals(node.asText())) {
            return CQL.star();
        }
        return SelectParser.selectListValue(node);
    }

    private SelectList createSelectList(SelectList.Type type, JsonNode node) {
        StructuredTypeRef prefix = TokenParser.ref(node);
        SelectList selectList = SelectList.create(prefix, type);
        ArrayNode inlineArrayNode = (ArrayNode)node.get(type.toString());
        if (inlineArrayNode.size() == 1 && inlineArrayNode.get(0).asText().equals("*")) {
            selectList.all();
        } else {
            for (JsonNode sli : inlineArrayNode) {
                CqnSelectListItem selectListItem = this.createSelectListItem(sli);
                selectList.items((Selectable)selectListItem);
            }
        }
        if (type == SelectList.Type.EXPAND) {
            this.limit(node).ifPresent(l -> ((ExpandBuilder)selectList).limit(l.top, l.skip));
            if (node.has("orderBy")) {
                List<CqnSortSpecification> order = SelectParser.orderBy((ArrayNode)node.get("orderBy"));
                ((ExpandBuilder)selectList).orderBy(order);
            }
        }
        return selectList;
    }

    private static CqnSelectListValue selectListValue(JsonNode node) {
        Object val = TokenParser.parseValue(node);
        if (val instanceof CqnSelectListValue) {
            return (CqnSelectListValue)val;
        }
        SelectListValueBuilder slv = SelectListValueBuilder.select(val);
        TokenParser.alias(node, slv::as);
        return slv.build();
    }

    private List<String> excluding() {
        ArrayNode cols = (ArrayNode)this.selectNode.withArray("excluding");
        ArrayList columns = Lists.newArrayList();
        for (JsonNode node : cols) {
            columns.add(node.asText());
        }
        return columns;
    }

    private CqnPredicate where() {
        JsonNode where = this.selectNode.get("where");
        return ExpressionParser.parsePredicate(where);
    }

    private CqnPredicate having() {
        JsonNode having = this.selectNode.get("having");
        return ExpressionParser.parsePredicate(having);
    }

    private CqnPredicate search() {
        JsonNode search = this.selectNode.get("search");
        return SearchParser.parseSearchExpression(search);
    }

    private CqnLock lock() {
        if (this.selectNode.has(FOR_UPDATE)) {
            return this.lock(CqnLock.Mode.EXCLUSIVE, this.selectNode.get(FOR_UPDATE));
        }
        if (this.selectNode.has(FOR_SHARE_LOCK)) {
            return this.lock(CqnLock.Mode.EXCLUSIVE, this.selectNode.get(FOR_SHARE_LOCK));
        }
        return null;
    }

    private CqnLock lock(CqnLock.Mode exclusive, JsonNode node) {
        if (node.has("wait")) {
            return new LockImpl(exclusive, node.get("wait").asInt());
        }
        return new LockImpl(exclusive);
    }

    private static class Limit {
        long top;
        long skip;

        private Limit() {
        }
    }
}

