/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.parser;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.sap.cds.impl.parser.JsonParser;
import com.sap.cds.ql.CdsDataException;
import com.sap.cds.reflect.CdsArrayedType;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsDefinition;
import com.sap.cds.reflect.CdsElementNotFoundException;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsSimpleType;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.util.CdsTypeUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class StructDataParser {
    private static final JsonMapper jackson = new JsonMapper();
    private final CdsStructuredType rootType;

    private StructDataParser(CdsStructuredType type) {
        this.rootType = type;
    }

    public static StructDataParser create(CdsStructuredType type) {
        return new StructDataParser(type);
    }

    public static List<?> parseArrayOf(CdsType itemType, String jsonArray) {
        return StructDataParser.parseArrayOf(itemType, jsonArray, Include.REJECTING);
    }

    public static List<?> parseArrayOf(CdsType itemType, String jsonArray, Include incl) {
        if (itemType.isSimple()) {
            return StructDataParser.parseArrayOf((CdsSimpleType)itemType.as(CdsSimpleType.class), jsonArray, incl);
        }
        if (itemType.isStructured()) {
            return StructDataParser.parseArrayOf((CdsStructuredType)itemType.as(CdsStructuredType.class), jsonArray, incl);
        }
        throw new IllegalArgumentException("Cannot parser array of type " + itemType);
    }

    public static <T> List<T> parseArrayOf(CdsSimpleType itemType, String jsonArray) {
        return StructDataParser.parseArrayOf(itemType, jsonArray, Include.REJECTING);
    }

    public static <T> List<T> parseArrayOf(CdsSimpleType itemType, String jsonArray, Include incl) {
        if (jsonArray != null) {
            ArrayNode data = (ArrayNode)JsonParser.parseJson(jsonArray);
            return StructDataParser.arrayToList((JsonNode)data, itemType, incl);
        }
        return null;
    }

    public static List<Map<String, Object>> parseArrayOf(CdsStructuredType itemType, String jsonArray) {
        return StructDataParser.parseArrayOf(itemType, jsonArray, Include.REJECTING);
    }

    public static List<Map<String, Object>> parseArrayOf(CdsStructuredType itemType, String jsonArray, Include incl) {
        if (jsonArray != null) {
            ArrayNode data = (ArrayNode)JsonParser.parseJson(jsonArray);
            return StructDataParser.arrayToList((JsonNode)data, itemType, incl);
        }
        return null;
    }

    public List<Map<String, Object>> parseArray(String jsonArray) {
        return this.parseArray(jsonArray, Include.REJECTING);
    }

    public List<Map<String, Object>> parseArray(String jsonArray, Include incl) {
        return StructDataParser.parseArrayOf(this.rootType, jsonArray, incl);
    }

    public Map<String, Object> parseObject(String jsonObject) {
        return this.parseObject(jsonObject, Include.REJECTING);
    }

    public Map<String, Object> parseObject(String jsonObject, Include incl) {
        return StructDataParser.objectToMap(JsonParser.parseJson(jsonObject), this.rootType, incl);
    }

    private static List<Map<String, Object>> arrayToList(JsonNode array, CdsStructuredType type, Include incl) {
        if (array != null) {
            return StreamSupport.stream(array.spliterator(), false).map(o -> StructDataParser.objectToMap(o, type, incl)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private static List<Object> arrayToList(JsonNode array, CdsSimpleType type, Include incl) {
        ArrayList<Object> data = new ArrayList<Object>();
        if (array != null) {
            array.forEach(entry -> data.add(StructDataParser.convertValue(entry, (CdsType)type, incl)));
        }
        return data;
    }

    private static Map<String, Object> objectToMap(JsonNode object, CdsStructuredType type, Include incl) {
        if (object == null) {
            return null;
        }
        HashMap<String, Object> data = new HashMap<String, Object>(object.size());
        object.fields().forEachRemaining(entry -> {
            String element = (String)entry.getKey();
            try {
                CdsType cdsType = type.findElement(element).map(e -> e.getType()).orElse(null);
                switch (incl) {
                    case GENERIC: {
                        data.put(element, StructDataParser.convertValue((JsonNode)entry.getValue(), cdsType, incl));
                        break;
                    }
                    case REJECTING: {
                        if (cdsType == null) {
                            throw new CdsElementNotFoundException(element, (CdsDefinition)type);
                        }
                        data.put(element, StructDataParser.convertValue((JsonNode)entry.getValue(), cdsType, incl));
                        break;
                    }
                    case IGNORING: {
                        if (cdsType == null) break;
                        data.put(element, StructDataParser.convertValue((JsonNode)entry.getValue(), cdsType, incl));
                    }
                }
            }
            catch (CdsDataException e2) {
                throw new CdsDataException("Cannot parse value for " + type.getQualifiedName() + ":" + element, (Throwable)e2);
            }
        });
        return data;
    }

    private static Object convertValue(JsonNode val, CdsType type, Include incl) {
        if (val.isNull()) {
            return null;
        }
        if (type == null) {
            try {
                return jackson.readValue(val.toString(), TypeFactory.unknownType());
            }
            catch (Exception e) {
                throw new UnsupportedOperationException("Cannot parse value '" + val + "' for undefined type.");
            }
        }
        if (type.isSimple() && val.isValueNode()) {
            return CdsTypeUtils.parse(((CdsSimpleType)type.as(CdsSimpleType.class)).getType(), val.asText());
        }
        if (type.isAssociation()) {
            CdsAssociationType assoc = (CdsAssociationType)type.as(CdsAssociationType.class);
            CdsEntity target = assoc.getTarget();
            if (assoc.getCardinality().getTargetMax().equals("1")) {
                return StructDataParser.objectToMap(val, (CdsStructuredType)target, incl);
            }
            return StructDataParser.arrayToList(val, (CdsStructuredType)target, incl);
        }
        if (type.isStructured() && val.isObject()) {
            return StructDataParser.objectToMap(val, (CdsStructuredType)type.as(CdsStructuredType.class), incl);
        }
        if (type.isArrayed() && val.isArray()) {
            CdsType itemType = ((CdsArrayedType)type.as(CdsArrayedType.class)).getItemsType();
            if (itemType.isStructured()) {
                return StructDataParser.arrayToList(val, (CdsStructuredType)itemType.as(CdsStructuredType.class), incl);
            }
            if (itemType.isSimple()) {
                return StructDataParser.arrayToList(val, (CdsSimpleType)itemType.as(CdsSimpleType.class), incl);
            }
        }
        throw new UnsupportedOperationException("Cannot parse " + type + " value: " + val);
    }

    public static enum Include {
        GENERIC,
        REJECTING,
        IGNORING;

    }
}

