/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.parser;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.google.common.collect.Lists;
import com.sap.cds.CdsException;
import com.sap.cds.impl.builder.model.ContainmentTest;
import com.sap.cds.impl.builder.model.CqnNull;
import com.sap.cds.impl.builder.model.CqnParam;
import com.sap.cds.impl.builder.model.ElementRefImpl;
import com.sap.cds.impl.builder.model.Join;
import com.sap.cds.impl.builder.model.ListValue;
import com.sap.cds.impl.builder.model.LiteralImpl;
import com.sap.cds.impl.builder.model.ScalarFunctionCall;
import com.sap.cds.impl.builder.model.StructuredTypeRefImpl;
import com.sap.cds.impl.parser.ExpressionParser;
import com.sap.cds.impl.parser.SelectParser;
import com.sap.cds.impl.parser.token.CqnPlainImpl;
import com.sap.cds.impl.parser.token.RefSegmentImpl;
import com.sap.cds.ql.CdsDataException;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.RefSegment;
import com.sap.cds.ql.StructuredTypeRef;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnExpression;
import com.sap.cds.ql.cqn.CqnFunc;
import com.sap.cds.ql.cqn.CqnJoin;
import com.sap.cds.ql.cqn.CqnLiteral;
import com.sap.cds.ql.cqn.CqnParameter;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnSource;
import com.sap.cds.ql.cqn.CqnSyntaxException;
import com.sap.cds.ql.cqn.CqnToken;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsSimpleType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.util.CdsTypeUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenParser {
    private static final Logger logger = LoggerFactory.getLogger(TokenParser.class);
    public static final String INVALID_CQN = "invalid CQN: ";

    private TokenParser() {
    }

    public static CqnToken parse(JsonNode node) {
        switch (node.getNodeType()) {
            case STRING: {
                String plain = node.asText();
                if ("null".equalsIgnoreCase(plain)) {
                    return CqnNull.getInstance();
                }
                return CqnPlainImpl.plain(plain);
            }
            case OBJECT: {
                if (node.has("SELECT")) {
                    return SelectParser.parse(node.toString());
                }
                if (node.has("join")) {
                    return TokenParser.join(node);
                }
                return TokenParser.parseValue(node);
            }
        }
        throw new CqnSyntaxException(INVALID_CQN + node);
    }

    static <T extends CqnValue> T parseValue(JsonNode node) {
        if (TokenParser.isParam(node)) {
            return (T)TokenParser.param(node);
        }
        if (node.has("ref")) {
            return (T)TokenParser.elementRef(node);
        }
        if (node.has("val")) {
            return (T)TokenParser.value(node);
        }
        if (node.has("xpr")) {
            return (T)TokenParser.xpr(node);
        }
        if (node.has("func")) {
            return (T)TokenParser.func(node);
        }
        if (node.has("list")) {
            return (T)TokenParser.list(node);
        }
        if (node.getNodeType() == JsonNodeType.STRING) {
            return (T)CqnPlainImpl.plain(node.asText());
        }
        throw new CqnSyntaxException(INVALID_CQN + node);
    }

    private static boolean isParam(JsonNode node) {
        return node.has("param") && node.get("param").booleanValue();
    }

    private static CqnParameter param(JsonNode objNode) {
        return CqnParam.param(objNode.get("ref").get(0).asText());
    }

    private static CqnValue value(JsonNode node) {
        Value<?> literal = node.has("literal") ? TokenParser.literalTypeVal(node) : TokenParser.jsonTypeVal(node);
        TokenParser.type(node, arg_0 -> literal.type(arg_0));
        return literal;
    }

    private static void type(JsonNode node, Consumer<String> c) {
        JsonNode cast;
        if (node.has("cast") && (cast = node.get("cast")).has("type")) {
            c.accept(cast.get("type").asText());
        }
    }

    public static CqnValue list(JsonNode objNode) {
        ArrayNode jsonArray = (ArrayNode)objNode.get("list");
        ArrayList values = new ArrayList(jsonArray.size());
        for (JsonNode node : jsonArray) {
            values.add(TokenParser.parseValue(node));
        }
        return ListValue.of(values);
    }

    private static Value<?> jsonTypeVal(JsonNode node) {
        JsonNode value = node.get("val");
        switch (value.getNodeType()) {
            case STRING: {
                return LiteralImpl.val(value.asText());
            }
            case NUMBER: {
                return LiteralImpl.val(value.numberValue());
            }
            case BOOLEAN: {
                return LiteralImpl.val(value.asBoolean());
            }
            case NULL: {
                return CqnNull.getInstance();
            }
        }
        throw new CqnSyntaxException(INVALID_CQN + value);
    }

    private static Value<?> literalTypeVal(JsonNode node) {
        String literalType = node.get("literal").asText();
        JsonNode value = node.get("val");
        switch (literalType) {
            case "timestamp": {
                return LiteralImpl.val(TokenParser.value(value, CdsBaseType.TIMESTAMP));
            }
            case "time": {
                return LiteralImpl.val(TokenParser.value(value, CdsBaseType.TIME));
            }
            case "date": {
                return LiteralImpl.val(TokenParser.value(value, CdsBaseType.DATE));
            }
            case "number": {
                return LiteralImpl.val(TokenParser.value(value, CdsBaseType.DECIMAL));
            }
            case "x": 
            case "hex": {
                return LiteralImpl.val(TokenParser.value(value, CdsBaseType.BINARY));
            }
            case "boolean": 
            case "string": {
                Value<?> jsonTypeVal = TokenParser.jsonTypeVal(node);
                TokenParser.checkTypeCompatability(jsonTypeVal.asLiteral(), literalType, value.asText());
                return jsonTypeVal;
            }
            case "null": {
                return TokenParser.jsonTypeVal(node);
            }
        }
        throw new CqnSyntaxException("Invalid CQN literal type: " + literalType);
    }

    private static void checkTypeCompatability(CqnLiteral<?> cqnLiteral, String literalType, String value) {
        String cqnLiteralType = (String)cqnLiteral.type().orElseThrow(() -> new CqnSyntaxException("CDS type not set for: " + cqnLiteral));
        if (!literalType.equals(CdsTypeUtils.cdsTypeShortName(cqnLiteralType))) {
            throw new CqnSyntaxException(MessageFormat.format("Value {0} cannot be converted to type {1}", value, literalType));
        }
    }

    public static CqnFunc func(JsonNode node) {
        String name = node.get("func").asText();
        Object func = null;
        if (node.has("args")) {
            JsonNode argsNode = node.get("args");
            if (argsNode.isArray()) {
                String lowerName;
                ArrayNode jsonArray = (ArrayNode)argsNode;
                CqnValue[] args = new CqnValue[jsonArray.size()];
                int i = 0;
                for (JsonNode arg : jsonArray) {
                    args[i] = TokenParser.parseValue(arg);
                    ++i;
                }
                switch (lowerName = name.toLowerCase(Locale.US)) {
                    case "startswith": {
                        func = ContainmentTest.startsWith(args[0], args[1]);
                        break;
                    }
                    case "contains": {
                        if (args.length < 3) {
                            func = ContainmentTest.contains(args[0], args[1]);
                            break;
                        }
                        boolean caseInsensitive = (Boolean)args[2].asLiteral().asBoolean().value();
                        func = ContainmentTest.contains(args[0], args[1], caseInsensitive);
                        break;
                    }
                    case "endswith": {
                        func = ContainmentTest.endsWith(args[0], args[1]);
                        break;
                    }
                    default: {
                        func = ScalarFunctionCall.create(name, args);
                        break;
                    }
                }
            } else {
                logger.warn("Named parameters in function call " + name + " are not supported");
                func = ScalarFunctionCall.create(name, new CqnValue[0]);
            }
        } else {
            func = ScalarFunctionCall.create(name, new CqnValue[0]);
        }
        if (func instanceof ScalarFunctionCall) {
            TokenParser.type(node, arg_0 -> ((Value)((Value)func)).type(arg_0));
        }
        return func;
    }

    public static CqnExpression xpr(JsonNode node) {
        JsonNode xprNode = node.get("xpr");
        if (xprNode.isArray()) {
            return ExpressionParser.parseExpression((ArrayNode)xprNode);
        }
        throw new CqnSyntaxException("xpr must be an array");
    }

    public static Object value(JsonNode value, CdsBaseType type) {
        switch (value.getNodeType()) {
            case STRING: 
            case NUMBER: 
            case BOOLEAN: {
                String txt = value.asText();
                try {
                    return CdsTypeUtils.parse(type, txt);
                }
                catch (CdsDataException ex) {
                    throw new CqnSyntaxException(ex.getMessage(), (Throwable)ex);
                }
            }
            case NULL: {
                return null;
            }
        }
        throw new CqnSyntaxException(INVALID_CQN + value);
    }

    public static Object defaultValue(JsonNode defValNode, CdsType type) {
        if (defValNode == null || type == null) {
            return null;
        }
        JsonNode valNode = defValNode.get("val");
        if (type.isSimple()) {
            if (valNode != null) {
                CdsBaseType cdsBaseType = ((CdsSimpleType)type.as(CdsSimpleType.class)).getType();
                return TokenParser.value(valNode, cdsBaseType);
            }
            return null;
        }
        throw new CdsException("Default values in parameters are not supported for type: " + type.getQualifiedName());
    }

    public static StructuredTypeRef ref(JsonNode node) {
        StructuredTypeRef typeRef = StructuredTypeRefImpl.typeRef(TokenParser.segments(node));
        TokenParser.alias(node, arg_0 -> ((StructuredTypeRef)typeRef).as(arg_0));
        return typeRef;
    }

    public static CqnElementRef elementRef(JsonNode node) {
        ElementRef elementRef = ElementRefImpl.element(TokenParser.segments(node));
        TokenParser.alias(node, arg_0 -> elementRef.as(arg_0));
        TokenParser.type(node, arg_0 -> elementRef.type(arg_0));
        return elementRef;
    }

    public static void alias(JsonNode node, Consumer<String> c) {
        if (node.has("as")) {
            c.accept(node.get("as").asText());
        }
    }

    private static List<CqnReference.Segment> segments(JsonNode objNode) {
        if (objNode.has("ref")) {
            ArrayList refObjects = Lists.newArrayList();
            ArrayNode jsonArray = (ArrayNode)objNode.get("ref");
            for (JsonNode node : jsonArray) {
                if (node.isTextual()) {
                    refObjects.add(RefSegmentImpl.refSegment(node.asText()));
                    continue;
                }
                refObjects.add(TokenParser.parseExpRefObject(node));
            }
            return refObjects;
        }
        logger.warn("The ObjectNode is not a reference: {}", (Object)objNode);
        ArrayList refObjects = Lists.newArrayList();
        refObjects.add(RefSegmentImpl.refSegment(objNode.asText()));
        return refObjects;
    }

    private static CqnReference.Segment parseExpRefObject(JsonNode node) {
        RefSegment segment = RefSegmentImpl.refSegment(node.get("id").asText());
        if (node.has("where")) {
            segment.filter(ExpressionParser.parsePredicate(node.get("where")));
        }
        return segment;
    }

    public static CqnJoin join(JsonNode from) {
        CqnJoin.Type type = CqnJoin.Type.joinType((String)from.get("join").asText());
        ArrayNode args = (ArrayNode)from.get("args");
        CqnSource left = TokenParser.source(args.get(0));
        CqnSource right = TokenParser.source(args.get(1));
        CqnPredicate joinPredicate = null;
        if (from.has("on")) {
            joinPredicate = ExpressionParser.parsePredicate(from.get("on"));
        }
        return new Join(type, left, right, joinPredicate);
    }

    static CqnSource source(JsonNode src) {
        if (src.has("ref")) {
            return TokenParser.ref(src);
        }
        if (src.has("join")) {
            return TokenParser.join(src);
        }
        if (src.has("SELECT")) {
            return SelectParser.parse(src.toString());
        }
        throw new CqnSyntaxException(INVALID_CQN + src);
    }
}

