/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.parser;

import com.sap.cds.reflect.impl.CdsVersion;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VersionParser {
    private static final String VERSION_PATTERN = "(\\d+)\\.(\\d+)\\.(\\d+)(?:\\-[ms]{2}\\.(\\d+))?";

    public static CdsVersion parse(String versionString) {
        Pattern pattern = Pattern.compile(VERSION_PATTERN);
        Matcher matcher = pattern.matcher(versionString);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.format("Unable to parse version string '%s'", versionString));
        }
        int major = Integer.valueOf(matcher.group(1));
        int minor = Integer.valueOf(matcher.group(2));
        int micro = Integer.valueOf(matcher.group(3));
        int buildNumber = matcher.group(4) == null ? 0 : Integer.valueOf(matcher.group(4));
        return new CdsVersion(major, minor, micro, buildNumber);
    }
}

