/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.parser;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.sap.cds.impl.parser.JsonParser;
import com.sap.cds.impl.parser.TokenParser;
import com.sap.cds.ql.Insert;
import com.sap.cds.ql.Upsert;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnSyntaxException;
import com.sap.cds.ql.impl.XsertBuilder;
import java.util.List;
import java.util.Map;

public class XsertParser {
    private JsonNode xsert;

    private XsertParser(JsonNode node, String kind) {
        this.xsert = node.get(kind);
    }

    private XsertParser(String cqn, String kind) {
        this.xsert = JsonParser.parseJson(cqn).get(kind);
    }

    public static Insert parseInsert(String cqn) {
        XsertParser parser = new XsertParser(cqn, "INSERT");
        return XsertBuilder.insert(parser.ref()).entries(parser.entries());
    }

    public static Upsert parseUpsert(String cqn) {
        XsertParser parser = new XsertParser(cqn, "UPSERT");
        return XsertBuilder.upsert(parser.ref()).entries(parser.entries());
    }

    private CqnStructuredTypeRef ref() {
        return TokenParser.ref(this.xsert.get("into"));
    }

    private List<Map<String, Object>> entries() {
        List<Map<String, Object>> entries = JsonParser.list((ArrayNode)this.xsert.withArray("entries"));
        if (entries.isEmpty()) {
            throw new CqnSyntaxException("INSERT/UPSERT without or with empty entries is not supported");
        }
        return entries;
    }
}

