/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.parser.builder;

import com.sap.cds.impl.parser.token.CqnNumLiteral;
import com.sap.cds.impl.parser.token.Jsonizer;
import com.sap.cds.ql.Limit;
import com.sap.cds.ql.cqn.CqnLimit;
import com.sap.cds.ql.cqn.CqnNumericLiteral;
import java.util.Optional;

public class LimitImpl
implements Limit {
    private final long top;
    private final long skip;

    private LimitImpl(long top, long skip) {
        this.top = top;
        this.skip = skip;
    }

    public long top() {
        return this.top;
    }

    public long skip() {
        return this.skip;
    }

    public Limit limit(long top, long skip) {
        return new LimitImpl(top, skip);
    }

    public static LimitImpl create(long top, long skip) {
        return new LimitImpl(top, skip);
    }

    public static LimitImpl create(CqnLimit other) {
        return LimitImpl.create(other.top(), other.skip());
    }

    public CqnNumericLiteral<Long> limit() {
        return new CqnNumLiteral<Long>(this.top, true);
    }

    public Optional<CqnNumericLiteral<Long>> offset() {
        return this.skip <= 0L ? Optional.empty() : Optional.of(new CqnNumLiteral<Long>(this.skip, false));
    }

    public String toJson() {
        Jsonizer jsonizer = Jsonizer.object("rows", this.limit());
        this.offset().ifPresent(o -> jsonizer.put("offset", o));
        return jsonizer.toJson();
    }

    public String toString() {
        return this.toJson();
    }
}

