/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.parser.builder;

import com.sap.cds.JSONizable;
import com.sap.cds.impl.parser.token.AbstractJSONizable;
import com.sap.cds.impl.parser.token.Jsonizer;
import com.sap.cds.ql.cqn.CqnSelectListValue;
import com.sap.cds.ql.cqn.CqnSortSpecification;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.impl.SelectListValueBuilder;

public class SortSpecificationImpl
extends AbstractJSONizable
implements CqnSortSpecification {
    private final CqnValue value;
    private final CqnSortSpecification.Order order;

    private SortSpecificationImpl(CqnValue item, CqnSortSpecification.Order order) {
        this.value = item;
        this.order = order;
    }

    public static CqnSortSpecification sort(CqnValue value, CqnSortSpecification.Order order) {
        return new SortSpecificationImpl(value, order);
    }

    public CqnValue value() {
        return this.value;
    }

    public CqnSortSpecification.Order order() {
        return this.order;
    }

    public String toJson() {
        Jsonizer cqn = Jsonizer.object((JSONizable)this.value);
        switch (this.order) {
            case DESC: {
                cqn.put("sort", this.order.sort);
                break;
            }
            case DESC_NULLS_FIRST: {
                cqn.put("sort", this.order.sort);
            }
            case ASC_NULLS_LAST: {
                cqn.put("nulls", this.order.nulls);
            }
        }
        return cqn.toJson();
    }

    public CqnSelectListValue item() {
        return SelectListValueBuilder.select(this.value).build();
    }
}

