/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.parser.token;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.util.RawValue;
import com.google.common.collect.Sets;
import com.sap.cds.CdsData;
import com.sap.cds.JSONizable;
import com.sap.cds.impl.Lazy;
import com.sap.cds.ql.cqn.CqnSyntaxException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Set;

public class Jsonizer
implements JSONizable {
    private static final ThreadLocal<Set<CdsData>> visited = new ThreadLocal();
    private static Jsonizer EMPTY = new Jsonizer(JsonNodeFactory.instance.objectNode());
    private static ObjectMapper mapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.ALWAYS).registerModule((Module)new SimpleModule().addSerializer((JsonSerializer)new JSONizableSerializer()).addSerializer((JsonSerializer)new InstantSerializer()).addSerializer((JsonSerializer)new LocalDateSerializer()).addSerializer((JsonSerializer)new ZonedDateTimeSerializer()).addSerializer((JsonSerializer)new LocalTimeSerializer()).addSerializer((JsonSerializer)new CdsDataSerializer()).addSerializer((JsonSerializer)new InputStreamSerializer()).addSerializer((JsonSerializer)new ReaderSerializer())).setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
    private final ObjectNode object;

    private Jsonizer(ObjectNode o) {
        this.object = o;
    }

    public static Jsonizer object(JSONizable j) {
        return new Jsonizer(Jsonizer.readObject(j.toJson()));
    }

    public static Jsonizer object(String key, Object value) {
        return new Jsonizer(mapper.createObjectNode().putPOJO(key, value));
    }

    public static Jsonizer object(String key, JSONizable value) {
        return new Jsonizer(mapper.createObjectNode().putRawValue(key, new RawValue(value.toJson())));
    }

    public static Jsonizer empty() {
        return EMPTY;
    }

    public static String json(Object o) {
        try {
            visited.set(Sets.newIdentityHashSet());
            String string = mapper.writeValueAsString(o);
            return string;
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Failed to serialize " + o + " to json: ", e);
        }
        finally {
            visited.remove();
        }
    }

    public static void write(Writer writer, Object o) throws IOException {
        try {
            mapper.writeValue(writer, o);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Failed to serialize " + o + " to json: ", e);
        }
    }

    private static ObjectNode readObject(String json) {
        try {
            return (ObjectNode)mapper.readTree(json);
        }
        catch (IOException e) {
            throw new CqnSyntaxException("Failed to parse '" + json + "': ", (Throwable)e);
        }
    }

    public Jsonizer put(String fieldName, Object value) {
        this.object.putPOJO(fieldName, value);
        return this;
    }

    public ObjectNode object(String fieldName) {
        return this.object.putObject(fieldName);
    }

    public ArrayNode array(String fieldName) {
        return this.object.putArray(fieldName);
    }

    public String toJson() {
        return Jsonizer.json(this.object);
    }

    private static class CdsDataSerializer
    extends StdSerializer<CdsData> {
        private static final long serialVersionUID = 1L;

        public CdsDataSerializer() {
            this(null);
        }

        public CdsDataSerializer(Class<CdsData> t) {
            super(t);
        }

        public Class<CdsData> handledType() {
            return CdsData.class;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serialize(CdsData data, JsonGenerator gen, SerializerProvider provider) throws IOException {
            Set v = (Set)visited.get();
            try {
                v.add(data);
                gen.writeStartObject();
                for (Map.Entry entry : data.entrySet()) {
                    Object value = entry.getValue();
                    if (value == null || value instanceof Lazy && !((Lazy)value).isLoaded() || v.contains(value)) continue;
                    gen.writeFieldName((String)entry.getKey());
                    gen.writeObject(value);
                }
                gen.writeEndObject();
            }
            finally {
                v.remove(data);
            }
        }
    }

    private static class ZonedDateTimeSerializer
    extends StdSerializer<ZonedDateTime> {
        private static final long serialVersionUID = 1L;

        public ZonedDateTimeSerializer() {
            this(null);
        }

        public ZonedDateTimeSerializer(Class<ZonedDateTime> t) {
            super(t);
        }

        public Class<ZonedDateTime> handledType() {
            return ZonedDateTime.class;
        }

        public void serialize(ZonedDateTime zonedDateTime, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeString(DateTimeFormatter.ISO_INSTANT.format(zonedDateTime));
        }
    }

    private static class LocalTimeSerializer
    extends StdSerializer<LocalTime> {
        private static final long serialVersionUID = 1L;

        public LocalTimeSerializer() {
            this(null);
        }

        public LocalTimeSerializer(Class<LocalTime> t) {
            super(t);
        }

        public Class<LocalTime> handledType() {
            return LocalTime.class;
        }

        public void serialize(LocalTime localTime, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeString(DateTimeFormatter.ISO_TIME.format(localTime));
        }
    }

    private static class LocalDateSerializer
    extends StdSerializer<LocalDate> {
        private static final long serialVersionUID = 1L;

        public LocalDateSerializer() {
            this(null);
        }

        public LocalDateSerializer(Class<LocalDate> t) {
            super(t);
        }

        public Class<LocalDate> handledType() {
            return LocalDate.class;
        }

        public void serialize(LocalDate localDate, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeString(DateTimeFormatter.ISO_DATE.format(localDate));
        }
    }

    private static class InstantSerializer
    extends StdSerializer<Instant> {
        private static final long serialVersionUID = 1L;

        public InstantSerializer() {
            this(null);
        }

        public InstantSerializer(Class<Instant> t) {
            super(t);
        }

        public Class<Instant> handledType() {
            return Instant.class;
        }

        public void serialize(Instant instant, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeString(DateTimeFormatter.ISO_INSTANT.format(instant));
        }
    }

    private static class InputStreamSerializer
    extends StdSerializer<InputStream> {
        private static final long serialVersionUID = 1L;

        protected InputStreamSerializer() {
            this(InputStream.class);
        }

        protected InputStreamSerializer(Class<InputStream> t) {
            super(t);
        }

        public Class<InputStream> handledType() {
            return InputStream.class;
        }

        public void serialize(InputStream inputStream, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeString("<DataStream>");
        }
    }

    private static class ReaderSerializer
    extends StdSerializer<Reader> {
        private static final long serialVersionUID = 1L;

        protected ReaderSerializer() {
            this(Reader.class);
        }

        protected ReaderSerializer(Class<Reader> t) {
            super(t);
        }

        public Class<Reader> handledType() {
            return Reader.class;
        }

        public void serialize(Reader reader, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeString("<DataStream>");
        }
    }

    private static class JSONizableSerializer
    extends StdSerializer<JSONizable> {
        private static final long serialVersionUID = 1L;

        public JSONizableSerializer() {
            this(null);
        }

        public JSONizableSerializer(Class<JSONizable> t) {
            super(t);
        }

        public Class<JSONizable> handledType() {
            return JSONizable.class;
        }

        public void serialize(JSONizable jsonizable, JsonGenerator gen, SerializerProvider provider) throws IOException {
            String json = jsonizable.toJson();
            if (json != null) {
                gen.writeRawValue(json);
            } else {
                gen.writeNull();
            }
        }
    }
}

