/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.parser.token;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.sap.cds.impl.parser.token.AbstractJSONizable;
import com.sap.cds.impl.parser.token.Jsonizer;
import com.sap.cds.ql.RefSegment;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.impl.ExpressionVisitor;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class RefSegmentImpl
extends AbstractJSONizable
implements RefSegment {
    private String id;
    private CqnPredicate filter;

    private RefSegmentImpl(String id, CqnPredicate filter) {
        this.id = id;
        this.filter = filter;
    }

    public static RefSegment refSegment(String id, CqnPredicate filter) {
        return new RefSegmentImpl(id, filter);
    }

    public static RefSegment refSegment(String id) {
        return new RefSegmentImpl(id, null);
    }

    public static RefSegment copy(CqnReference.Segment segment) {
        CqnPredicate filter = segment.filter().map(ExpressionVisitor::copy).orElse(null);
        return RefSegmentImpl.refSegment(segment.id(), filter);
    }

    public static List<RefSegment> copy(List<? extends CqnReference.Segment> segments) {
        ArrayList<RefSegment> copy = new ArrayList<RefSegment>();
        segments.forEach(s -> copy.add(RefSegmentImpl.copy(s)));
        return copy;
    }

    public Optional<CqnPredicate> filter() {
        return Optional.ofNullable(this.filter);
    }

    public String id() {
        return this.id;
    }

    public RefSegment id(String id) {
        this.id = id;
        return this;
    }

    public RefSegment filter(CqnPredicate filter) {
        this.filter = filter;
        return this;
    }

    public String toJson() {
        if (this.filter != null) {
            Jsonizer cqn = Jsonizer.object("id", this.id);
            ArrayNode where = cqn.array("where");
            this.filter.tokens().forEach(arg_0 -> ((ArrayNode)where).addPOJO(arg_0));
            return cqn.toJson();
        }
        return Jsonizer.json(this.id);
    }

    public void clearFilter() {
        this.filter = null;
    }
}

