/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.ql.impl;

import com.sap.cds.ql.cqn.AnalysisResult;
import com.sap.cds.ql.cqn.CqnAnalyzer;
import com.sap.cds.ql.cqn.CqnComparisonPredicate;
import com.sap.cds.ql.cqn.CqnConnectivePredicate;
import com.sap.cds.ql.cqn.CqnDelete;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnInPredicate;
import com.sap.cds.ql.cqn.CqnNegation;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnSelectListValue;
import com.sap.cds.ql.cqn.CqnSource;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnUpdate;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.cqn.CqnVisitor;
import com.sap.cds.ql.cqn.ResolvedRefItem;
import com.sap.cds.ql.cqn.ResolvedSegment;
import com.sap.cds.ql.impl.PathImpl;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.CqnStatementUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class CqnAnalyzerImpl
implements CqnAnalyzer.CqnAnalyzerSPI {
    private static final String COUNT = "COUNT";
    private static final String COUNT_DISTINCT = "countDistinct";

    public boolean isCountQuery(CqnStatement cqn) {
        CqnValue val;
        CqnSelectListItem item;
        if (cqn.isSelect() && cqn.asSelect().items().size() == 1 && (item = (CqnSelectListItem)cqn.asSelect().items().get(0)).isValue() && (val = item.asValue().value()).isFunction()) {
            String func = val.asFunction().func();
            return COUNT.equals(func.toUpperCase(Locale.US)) || COUNT_DISTINCT.equals(func);
        }
        return false;
    }

    public AnalysisResult analyze(CdsModel model, CqnStructuredTypeRef ref) {
        List<ResolvedSegment> segments = this.resolveSegments(model, ref.segments());
        return new Result(segments, Optional.empty());
    }

    public AnalysisResult analyze(CdsModel model, CqnSelect select) {
        List<ResolvedSegment> segments = this.resolveSegments(model, select.ref().segments());
        return new Result(segments, select.where());
    }

    public AnalysisResult analyze(CdsModel model, CqnUpdate update) {
        List<ResolvedSegment> segments = this.resolveSegments(model, update.ref().segments());
        return new Result(segments, update.where());
    }

    public AnalysisResult analyze(CdsModel model, CqnDelete delete) {
        List<ResolvedSegment> segments = this.resolveSegments(model, delete.ref().segments());
        return new Result(segments, delete.where());
    }

    public Iterable<ResolvedRefItem> resolveRefItems(CdsModel model, CqnSelect query) {
        return CqnAnalyzerImpl.resolveRefItems(model, query, i -> true);
    }

    private static List<ResolvedRefItem> resolveRefItems(CdsModel model, CqnSelect query, Predicate<CqnSelectListValue> filter) {
        CqnSource from = query.from();
        if (from.isRef()) {
            CdsEntity target = CdsModelUtils.entity(model, from.asRef());
            query = CqnStatementUtils.resolveStar(query, (CdsStructuredType)target);
            return CqnStatementUtils.selectedRefs(query).filter(filter).map(r -> new ResolvedRef(model, target, (CqnSelectListValue)r)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private List<ResolvedSegment> resolveSegments(CdsModel model, List<? extends CqnReference.Segment> segments) {
        List<CdsEntity> entities = CdsModelUtils.entities(model, segments);
        return IntStream.range(0, segments.size()).mapToObj(i -> new ResolvedSeg((CqnReference.Segment)segments.get(i), (CdsEntity)entities.get(i), Optional.empty())).collect(Collectors.toList());
    }

    public static Map<String, Object> extractKeys(CqnReference.Segment seg, CdsEntity entity) {
        Optional filter = seg.filter();
        if (filter.isPresent()) {
            return new ResolvedSeg(seg, entity, filter).keys();
        }
        return Collections.emptyMap();
    }

    private static final class ValueExtractor
    implements CqnVisitor {
        private final Map<String, Object> values;
        private boolean ambiguous;
        private boolean add;

        private ValueExtractor(Map<String, Object> values, boolean add) {
            this.values = values;
            this.add = add;
        }

        static ValueExtractor addValues(Map<String, Object> values) {
            return new ValueExtractor(values, true);
        }

        static ValueExtractor removeValues(Map<String, Object> values) {
            return new ValueExtractor(values, false);
        }

        public void visit(CqnComparisonPredicate predicate) {
            if (predicate.operator() == CqnComparisonPredicate.Operator.EQ || predicate.operator() == CqnComparisonPredicate.Operator.IS) {
                CqnValue left = predicate.left();
                CqnValue right = predicate.right();
                if (left.isRef()) {
                    this.addKey((CqnElementRef)left, right);
                } else if (right.isRef()) {
                    this.addKey((CqnElementRef)right, left);
                }
            }
        }

        public void visit(CqnInPredicate in) {
            CqnValue val = in.value();
            if (val.isRef() && in.valueSet().isList()) {
                in.values().forEach(v -> this.addKey(val.asRef(), (CqnValue)v));
            }
        }

        public void visit(CqnConnectivePredicate con) {
            if (con.operator() == CqnConnectivePredicate.Operator.OR) {
                this.clearValues();
            }
        }

        public void visit(CqnNegation neg) {
            neg.predicate().accept((CqnVisitor)ValueExtractor.removeValues(this.values));
        }

        private void clearValues() {
            this.values.clear();
        }

        private void addKey(CqnElementRef element, CqnValue value) {
            if (element.segments().size() == 1) {
                String name = element.displayName();
                if (!this.ambiguous) {
                    if (this.add) {
                        Object val = this.value(value);
                        Object oldVal = this.values.put(name, val);
                        if (oldVal != null && !Objects.equals(oldVal, val)) {
                            this.ambiguous = true;
                            this.clearValues();
                        }
                    } else {
                        this.values.remove(name);
                    }
                }
            }
        }

        private Object value(CqnValue value) {
            if (value.isLiteral()) {
                return value.asLiteral().value();
            }
            if (value.isNullValue()) {
                return null;
            }
            return value;
        }
    }

    private static class ResolvedSeg
    extends PathImpl.ResolvedSegImpl {
        private final List<CqnPredicate> filters = new ArrayList<CqnPredicate>(1);

        private ResolvedSeg(CqnReference.Segment segment, CdsEntity entity, Optional<CqnPredicate> where) {
            super(segment, (CdsStructuredType)entity);
            segment.filter().ifPresent(this.filters::add);
            where.ifPresent(this.filters::add);
        }

        @Override
        public Map<String, Object> values() {
            HashMap<String, Object> values = new HashMap<String, Object>();
            ValueExtractor valExtractor = ValueExtractor.addValues(values);
            this.filters.forEach(f -> f.accept((CqnVisitor)valExtractor));
            return values;
        }
    }

    private static class Result
    extends PathImpl
    implements AnalysisResult {
        private final Optional<CqnPredicate> where;

        public Result(List<ResolvedSegment> segments, Optional<CqnPredicate> where) {
            super(new LinkedList<ResolvedSegment>(segments));
            this.where = where;
        }

        public CdsEntity rootEntity() {
            return this.root().entity();
        }

        public Map<String, Object> rootKeys() {
            return this.root().keys();
        }

        public CdsEntity targetEntity() {
            return this.target().entity();
        }

        public Map<String, Object> targetKeys() {
            return this.target(ResolvedSegment::keys);
        }

        public Map<String, Object> targetKeyValues() {
            return this.target(ResolvedSegment::keyValues);
        }

        public Map<String, Object> targetValues() {
            return this.target(ResolvedSegment::values);
        }

        private Map<String, Object> target(Function<ResolvedSegment, Map<String, Object>> filter) {
            ResolvedSegment target = this.target();
            if (this.where.isPresent()) {
                target = new ResolvedSeg(target.segment(), target.entity(), this.where);
            }
            return filter.apply(target);
        }
    }

    private static class ResolvedRef
    implements ResolvedRefItem {
        private final CdsModel model;
        private final CdsEntity entity;
        private final CqnSelectListValue value;
        private final CqnElementRef ref;

        private ResolvedRef(CdsModel model, CdsEntity entity, CqnSelectListValue value) {
            this.model = model;
            this.entity = entity;
            this.value = value;
            this.ref = value.value().asRef();
        }

        public String displayName() {
            return this.value.displayName();
        }

        public CqnElementRef ref() {
            return this.ref;
        }

        public CdsElement element() {
            return CdsModelUtils.element((CdsStructuredType)this.entity, this.ref);
        }

        public Optional<ResolvedRefItem> origin() {
            List refs;
            Optional projection = this.entity.query();
            if (projection.isPresent() && !(refs = CqnAnalyzerImpl.resolveRefItems(this.model, (CqnSelect)projection.get(), i -> i.displayName().equals(this.ref.lastSegment()))).isEmpty()) {
                return Optional.of(refs.get(0));
            }
            return Optional.empty();
        }
    }
}

