/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.ql.impl;

import com.sap.cds.impl.builder.model.ArithmeticExpr;
import com.sap.cds.impl.builder.model.BooleanFunctionCall;
import com.sap.cds.impl.builder.model.ComparisonPredicate;
import com.sap.cds.impl.builder.model.Conjunction;
import com.sap.cds.impl.builder.model.Connective;
import com.sap.cds.impl.builder.model.ContainmentTest;
import com.sap.cds.impl.builder.model.CqnParam;
import com.sap.cds.impl.builder.model.Disjunction;
import com.sap.cds.impl.builder.model.ElementRefImpl;
import com.sap.cds.impl.builder.model.ExistsSubquery;
import com.sap.cds.impl.builder.model.ExpressionImpl;
import com.sap.cds.impl.builder.model.InPredicate;
import com.sap.cds.impl.builder.model.ListValue;
import com.sap.cds.impl.builder.model.LiteralImpl;
import com.sap.cds.impl.builder.model.MatchPredicate;
import com.sap.cds.impl.builder.model.Negation;
import com.sap.cds.impl.builder.model.ScalarFunctionCall;
import com.sap.cds.impl.builder.model.SearchPredicate;
import com.sap.cds.impl.builder.model.StructuredTypeImpl;
import com.sap.cds.impl.builder.model.StructuredTypeProxy;
import com.sap.cds.impl.builder.model.StructuredTypeRefImpl;
import com.sap.cds.impl.parser.builder.SortSpecificationImpl;
import com.sap.cds.impl.parser.token.CqnPlainImpl;
import com.sap.cds.impl.parser.token.RefSegmentImpl;
import com.sap.cds.ql.BooleanFunction;
import com.sap.cds.ql.CqnBuilder;
import com.sap.cds.ql.CqnParser;
import com.sap.cds.ql.Delete;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.FunctionCall;
import com.sap.cds.ql.Insert;
import com.sap.cds.ql.Literal;
import com.sap.cds.ql.Parameter;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.RefSegment;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.Source;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.StructuredTypeRef;
import com.sap.cds.ql.Update;
import com.sap.cds.ql.Upsert;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.CqnArithmeticExpression;
import com.sap.cds.ql.cqn.CqnComparisonPredicate;
import com.sap.cds.ql.cqn.CqnConnectivePredicate;
import com.sap.cds.ql.cqn.CqnContainmentTest;
import com.sap.cds.ql.cqn.CqnListValue;
import com.sap.cds.ql.cqn.CqnMatchPredicate;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSortSpecification;
import com.sap.cds.ql.cqn.CqnSource;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.cqn.Modifier;
import com.sap.cds.ql.impl.CqnParserImpl;
import com.sap.cds.ql.impl.DeleteBuilder;
import com.sap.cds.ql.impl.ExpressionVisitor;
import com.sap.cds.ql.impl.SelectBuilder;
import com.sap.cds.ql.impl.UpdateBuilder;
import com.sap.cds.ql.impl.XsertBuilder;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsEntity;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public class CqnBuilderImpl
implements CqnBuilder {
    private final CqnParserImpl parser = new CqnParserImpl();

    public Select<StructuredType<?>> select(CqnStructuredTypeRef ref) {
        return SelectBuilder.from(ref);
    }

    public Insert insert(CqnStructuredTypeRef ref) {
        return XsertBuilder.insert(ref);
    }

    public Upsert upsert(CqnStructuredTypeRef ref) {
        return XsertBuilder.upsert(ref);
    }

    public Update<StructuredType<?>> update(CqnStructuredTypeRef ref) {
        return UpdateBuilder.entity(ref);
    }

    public Delete<StructuredType<?>> delete(CqnStructuredTypeRef ref) {
        return DeleteBuilder.from(ref);
    }

    public <E extends StructuredType<E>> Select<E> select(Source<E> source) {
        return SelectBuilder.from(source);
    }

    public Select<StructuredType<?>> select(String entityName) {
        return SelectBuilder.from(entityName);
    }

    public Select<StructuredType<?>> select(String entityName, UnaryOperator<StructuredType<?>> path) {
        return SelectBuilder.from(entityName, path);
    }

    public Insert insert(String entityName, UnaryOperator<StructuredType<?>> path) {
        StructuredTypeRef structType = CqnBuilderImpl.applyPath(entityName, path);
        return XsertBuilder.insert((CqnStructuredTypeRef)structType);
    }

    public Upsert upsert(String entityName, UnaryOperator<StructuredType<?>> path) {
        StructuredTypeRef structType = CqnBuilderImpl.applyPath(entityName, path);
        return XsertBuilder.upsert((CqnStructuredTypeRef)structType);
    }

    public Update<StructuredType<?>> update(String entityName, UnaryOperator<StructuredType<?>> path) {
        StructuredTypeRef structType = CqnBuilderImpl.applyPath(entityName, path);
        return UpdateBuilder.entity((CqnStructuredTypeRef)structType);
    }

    public Update<StructuredType<?>> update(CdsEntity entity, UnaryOperator<StructuredType<?>> path) {
        return this.update(entity.getQualifiedName(), path);
    }

    public Delete<StructuredType<?>> delete(String entityName, UnaryOperator<StructuredType<?>> path) {
        StructuredTypeRef structType = CqnBuilderImpl.applyPath(entityName, path);
        return DeleteBuilder.from((CqnStructuredTypeRef)structType);
    }

    private static StructuredTypeRef applyPath(String entityName, UnaryOperator<StructuredType<?>> path) {
        StructuredTypeImpl root = StructuredTypeImpl.structuredType(entityName);
        return StructuredTypeRefImpl.typeRef((CqnSource)path.apply(root));
    }

    public <E extends StructuredType<E>> Select<E> select(Class<E> entity) {
        return this.select((Source<E>)StructuredTypeProxy.create(entity));
    }

    public <E extends StructuredType<E>, R extends StructuredType<R>> Select<R> select(Class<E> entity, Function<E, R> path) {
        return this.select((Source)path.apply(StructuredTypeProxy.create(entity)));
    }

    public Select<StructuredType<?>> select(CqnSelect select) {
        return SelectBuilder.from(select);
    }

    public <E extends StructuredType<E>, R extends StructuredType<R>> Insert insert(Class<E> entity, Function<E, R> path) {
        return XsertBuilder.insert((StructuredType)path.apply(StructuredTypeProxy.create(entity)));
    }

    public <E extends StructuredType<E>, R extends StructuredType<R>> Upsert upsert(Class<E> entity, Function<E, R> path) {
        return XsertBuilder.upsert((StructuredType)path.apply(StructuredTypeProxy.create(entity)));
    }

    public <E extends StructuredType<E>, R extends StructuredType<R>> Update<R> update(Class<E> entity, Function<E, R> path) {
        return UpdateBuilder.entity((StructuredType)path.apply(StructuredTypeProxy.create(entity)));
    }

    public <E extends StructuredType<E>, R extends StructuredType<R>> Delete<R> delete(Class<E> entity, Function<E, R> path) {
        return DeleteBuilder.from((StructuredType)path.apply(StructuredTypeProxy.create(entity)));
    }

    public Select<StructuredType<?>> select(CdsEntity entity) {
        return this.select(entity.getQualifiedName());
    }

    public Select<StructuredType<?>> select(CdsEntity entity, UnaryOperator<StructuredType<?>> path) {
        return this.select(entity.getQualifiedName(), path);
    }

    public Insert insert(CdsEntity entity, UnaryOperator<StructuredType<?>> path) {
        return this.insert(entity.getQualifiedName(), path);
    }

    public Upsert upsert(CdsEntity entity, UnaryOperator<StructuredType<?>> path) {
        return this.upsert(entity.getQualifiedName(), path);
    }

    public Delete<StructuredType<?>> delete(CdsEntity entity, UnaryOperator<StructuredType<?>> path) {
        return this.delete(entity.getQualifiedName(), path);
    }

    public <E extends StructuredType<?>> Delete<E> delete(E entity) {
        return DeleteBuilder.from(entity);
    }

    public <E extends StructuredType<?>> Insert insert(E entity) {
        return XsertBuilder.insert(entity);
    }

    public <E extends StructuredType<?>> Upsert upsert(E entity) {
        return XsertBuilder.upsert(entity);
    }

    public <E extends StructuredType<?>> Update<E> update(E entity) {
        return UpdateBuilder.entity(entity);
    }

    public <S extends CqnStatement, R extends S> R copy(S statement) {
        return this.copy(statement, ExpressionVisitor.COPY);
    }

    public <S extends CqnStatement, R extends S> R copy(S statement, Modifier modifier) {
        if (statement.isSelect()) {
            return (R)((Object)SelectBuilder.copy(statement.asSelect(), modifier));
        }
        if (statement.isInsert()) {
            return (R)XsertBuilder.copy(statement.asInsert(), modifier);
        }
        if (statement.isUpsert()) {
            return (R)XsertBuilder.copy(statement.asUpsert(), modifier);
        }
        if (statement.isUpdate()) {
            return (R)UpdateBuilder.copy(statement.asUpdate(), modifier);
        }
        if (statement.isDelete()) {
            return (R)DeleteBuilder.copy(statement.asDelete(), modifier);
        }
        throw new UnsupportedOperationException("Cannot copy statement " + statement);
    }

    public Predicate copy(CqnPredicate pred) {
        return ExpressionVisitor.copy(pred);
    }

    public Predicate copy(CqnPredicate pred, Modifier modifier) {
        return ExpressionVisitor.copy(pred, modifier);
    }

    public CqnParser parse() {
        return this.parser;
    }

    public CqnBuilder.QueryBuilderSupport support() {
        return new CqnBuilder.QueryBuilderSupport(){

            public <T> Parameter<T> param() {
                return CqnParam.param();
            }

            public <T> Parameter<T> param(String name) {
                return CqnParam.param(name);
            }

            public <T> FunctionCall<T> func(String functionName, Iterable<? extends CqnValue> args) {
                FunctionCall func;
                block3: {
                    block2: {
                        func = ScalarFunctionCall.create(functionName, args);
                        if ("max".equalsIgnoreCase(functionName)) break block2;
                        if (!"min".equalsIgnoreCase(functionName)) break block3;
                    }
                    args.iterator().next().type().ifPresent(arg_0 -> func.type(arg_0));
                }
                return func;
            }

            public BooleanFunction booleanFunc(String functionName, List<? extends CqnValue> args) {
                return BooleanFunctionCall.create(functionName, args);
            }

            public CqnListValue list(List<? extends CqnValue> values) {
                return ListValue.of(values);
            }

            public <T> Literal<T> literal(T val) {
                return LiteralImpl.val(val);
            }

            public <T> Literal<T> constant(T value) {
                return LiteralImpl.constant(value);
            }

            public <T> Literal<T> val(T value) {
                return LiteralImpl.val(value);
            }

            public Value<?> plain(String val) {
                return CqnPlainImpl.plain(val);
            }

            public Predicate not(CqnPredicate p) {
                return Negation.not(p);
            }

            public Predicate connect(CqnConnectivePredicate.Operator operator, Iterable<? extends CqnPredicate> predicates) {
                return Connective.create(operator, predicates);
            }

            public Value<String> toLower(Value<String> val) {
                return ScalarFunctionCall.create("tolower", new CqnValue[]{val}).type(CdsBaseType.STRING);
            }

            public Value<String> toUpper(Value<String> val) {
                return ScalarFunctionCall.create("toupper", new CqnValue[]{val}).type(CdsBaseType.STRING);
            }

            public StructuredType<?> entity(String qualifiedName) {
                return StructuredTypeImpl.structuredType(qualifiedName);
            }

            public <T> ElementRef<T> get(String path) {
                return ElementRefImpl.parse(path);
            }

            public <T> ElementRef<T> get(List<? extends CqnReference.Segment> segments) {
                return ElementRefImpl.element(segments);
            }

            public StructuredType<?> to(String path) {
                return StructuredTypeImpl.structuredType(StructuredTypeRefImpl.typeRef(path.split("\\.")));
            }

            public StructuredType<?> to(List<? extends CqnReference.Segment> segments) {
                return StructuredTypeImpl.structuredType(StructuredTypeRefImpl.typeRef(segments));
            }

            public RefSegment refSegment(String id) {
                return RefSegmentImpl.refSegment(id);
            }

            public List<RefSegment> refSegments(List<String> segmentIds) {
                return segmentIds.stream().map(this::refSegment).collect(Collectors.toList());
            }

            public Value<Number> expression(CqnValue left, CqnArithmeticExpression.Operator op, CqnValue right) {
                return ArithmeticExpr.expression(left, op, right);
            }

            public Predicate comparison(CqnValue lhs, CqnComparisonPredicate.Operator op, CqnValue rhs) {
                return ComparisonPredicate.pred(lhs, op, rhs);
            }

            public Predicate in(CqnValue lhs, Collection<? extends CqnValue> values) {
                return InPredicate.in(lhs, values.stream());
            }

            public Predicate in(CqnValue lhs, CqnValue valueSet) {
                return InPredicate.in(lhs, valueSet);
            }

            public Predicate search(String term) {
                return new SearchPredicate(term);
            }

            public Predicate exists(CqnSelect subQuery) {
                return new ExistsSubquery(subQuery);
            }

            public Predicate match(StructuredTypeRef ref, Predicate pred, CqnMatchPredicate.Quantifier quantifier) {
                MatchPredicate match = quantifier == CqnMatchPredicate.Quantifier.ALL ? MatchPredicate.all((CqnStructuredTypeRef)ref, (CqnPredicate)pred) : MatchPredicate.any((CqnStructuredTypeRef)ref, (CqnPredicate)pred);
                return match;
            }

            public ElementRef<Instant> now() {
                return this.get("$now");
            }

            public ElementRef<Instant> validFrom() {
                return ElementRefImpl.element("$at", "from");
            }

            public ElementRef<Instant> validTo() {
                return ElementRefImpl.element("$at", "to");
            }

            public ElementRef<String> userLocale() {
                return ElementRefImpl.element("$user", "locale");
            }

            public ElementRef<String> userId() {
                return ElementRefImpl.element("$user", "id");
            }

            public Value<Long> countDistinct(CqnValue value) {
                return ScalarFunctionCall.create("countDistinct", value).type(Long.class);
            }

            public Predicate containment(CqnContainmentTest.Position position, CqnValue value, CqnValue term, boolean caseInsensitive) {
                return ContainmentTest.create(position, value, term, caseInsensitive);
            }

            public CqnSortSpecification sort(CqnValue value, CqnSortSpecification.Order order) {
                return SortSpecificationImpl.sort(value, order);
            }

            public Collector<CqnPredicate, ?, CqnPredicate> withOr() {
                return Disjunction.or();
            }

            public Collector<CqnPredicate, ?, CqnPredicate> withAnd() {
                return Conjunction.and();
            }
        };
    }

    public Predicate matching(Map<String, ?> keyValueMap) {
        return ExpressionImpl.matching(keyValueMap);
    }
}

