/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.ql.impl;

import com.sap.cds.impl.builder.model.StructuredTypeImpl;
import com.sap.cds.impl.parser.DeleteParser;
import com.sap.cds.impl.parser.SelectParser;
import com.sap.cds.impl.parser.UpdateParser;
import com.sap.cds.impl.parser.XsertParser;
import com.sap.cds.ql.CqnParser;
import com.sap.cds.ql.Delete;
import com.sap.cds.ql.Insert;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.Update;
import com.sap.cds.ql.Upsert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CqnParserImpl
implements CqnParser {
    private static final Logger logger = LoggerFactory.getLogger(CqnParserImpl.class);

    public Select<StructuredType<?>> select(String cqn) {
        try {
            Select<StructuredTypeImpl> select = SelectParser.parse(cqn);
            return select;
        }
        catch (UnsupportedOperationException e) {
            logger.warn("Failed to parse CQN Select: " + cqn, (Throwable)e);
            return null;
        }
    }

    public Insert insert(String cqn) {
        return XsertParser.parseInsert(cqn);
    }

    public Upsert upsert(String cqn) {
        return XsertParser.parseUpsert(cqn);
    }

    public Update<StructuredType<?>> update(String cqn) {
        return UpdateParser.parse(cqn);
    }

    public Delete<StructuredType<?>> delete(String cqn) {
        return DeleteParser.parse(cqn);
    }
}

