/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.ql.impl;

import com.google.common.collect.Maps;
import com.sap.cds.impl.builder.model.ExpressionImpl;
import com.sap.cds.impl.builder.model.StructuredTypeRefImpl;
import com.sap.cds.impl.parser.token.RefSegmentImpl;
import com.sap.cds.ql.RefSegment;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.Path;
import com.sap.cds.ql.cqn.ResolvedSegment;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.util.CdsModelUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class PathImpl
implements Path {
    private final LinkedList<ResolvedSegment> segments;

    public PathImpl(LinkedList<ResolvedSegment> segments) {
        this.segments = segments;
    }

    public Iterator<ResolvedSegment> iterator() {
        return this.segments.iterator();
    }

    public Iterator<ResolvedSegment> reverse() {
        final ListIterator<ResolvedSegment> li = this.segments.listIterator(this.segments.size());
        return new Iterator<ResolvedSegment>(){

            @Override
            public boolean hasNext() {
                return li.hasPrevious();
            }

            @Override
            public ResolvedSegment next() {
                return (ResolvedSegment)li.previous();
            }
        };
    }

    public ResolvedSegment root() {
        return this.segments.getFirst();
    }

    public ResolvedSegment target() {
        return this.segments.getLast();
    }

    public Path append(CdsElement element, CdsStructuredType type) {
        return this.append(element, type, new HashMap<String, Object>());
    }

    public Path append(CdsElement element, CdsStructuredType type, Map<String, Object> entry) {
        LinkedList<ResolvedSegment> p = new LinkedList<ResolvedSegment>(this.segments);
        p.add(new ResolvedSegImpl(element, type, entry));
        return new PathImpl(p);
    }

    public CqnReference toRef() {
        List segs = this.segments.stream().map(ResolvedSegment::segment).collect(Collectors.toList());
        return StructuredTypeRefImpl.typeRef(segs);
    }

    public String toString() {
        return this.toRef().toJson();
    }

    static class ResolvedSegImpl
    implements ResolvedSegment {
        private CqnReference.Segment segment;
        private final CdsElement element;
        private final CdsStructuredType type;
        private final Map<String, Object> filter;

        ResolvedSegImpl(CdsElement element, CdsStructuredType type, Map<String, Object> filter) {
            this.element = element;
            this.type = type;
            this.filter = filter;
        }

        ResolvedSegImpl(CqnReference.Segment segment, CdsStructuredType type) {
            this.segment = segment;
            this.element = null;
            this.type = type;
            this.filter = new HashMap<String, Object>();
        }

        public CqnReference.Segment segment() {
            if (this.segment == null) {
                RefSegment seg = this.element == null ? RefSegmentImpl.refSegment(this.type.getQualifiedName()) : RefSegmentImpl.refSegment(this.element.getName());
                Map<String, Object> values = this.keyValues();
                if (values.isEmpty()) {
                    values = this.values();
                }
                if (!values.isEmpty()) {
                    seg.filter((CqnPredicate)ExpressionImpl.matching(values));
                }
                this.segment = seg;
            }
            return this.segment;
        }

        public CdsStructuredType type() {
            return this.type;
        }

        public CdsElement element() {
            return this.element;
        }

        public Map<String, Object> values() {
            return this.filter;
        }

        public Map<String, Object> keys() {
            return this.keyValues(true);
        }

        public Map<String, Object> keyValues() {
            return this.keyValues(false);
        }

        private Map<String, Object> keyValues(boolean emptyToNull) {
            Set<String> keyNames = CdsModelUtils.keyNames(this.type);
            Map<String, Object> values = this.values();
            if (values.containsKey("$key")) {
                String key = keyNames.iterator().next();
                values.put(key, values.remove("$key"));
            }
            if (emptyToNull) {
                keyNames.forEach(k -> values.putIfAbsent((String)k, null));
            }
            return new HashMap<String, Object>(Maps.filterKeys(values, keyNames::contains));
        }

        public String toString() {
            return this.segment().toJson();
        }
    }
}

