/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.ql.impl;

import com.sap.cds.JSONizable;
import com.sap.cds.impl.builder.model.ElementRefImpl;
import com.sap.cds.impl.parser.token.Jsonizer;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.Selectable;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnPlain;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnSelectListValue;
import com.sap.cds.ql.cqn.CqnValue;
import java.util.Optional;

public class SelectListValueBuilder {
    private final CqnValue value;
    private String alias = null;

    private SelectListValueBuilder(CqnValue value) {
        this.value = value;
    }

    public static SelectListValueBuilder select(CqnValue value) {
        return new SelectListValueBuilder(value);
    }

    public static CqnSelectListValue select(CqnElementRef ref) {
        SelectListValueBuilder slv = new SelectListValueBuilder((CqnValue)ref);
        return slv.build();
    }

    public static CqnSelectListItem refToSlv(Selectable selectable) {
        if (selectable instanceof CqnElementRef) {
            CqnElementRef elementRef = (CqnElementRef)selectable;
            return SelectListValueBuilder.select(elementRef);
        }
        if (selectable instanceof StructuredType) {
            ElementRef elementRef = ElementRefImpl.elementRef((CqnReference)((StructuredType)selectable).asRef());
            return SelectListValueBuilder.select(elementRef);
        }
        return (CqnSelectListItem)selectable;
    }

    public SelectListValueBuilder as(String alias) {
        if (this.value.isRef()) {
            ((Value)this.value).as(alias);
        }
        this.alias = alias;
        return this;
    }

    public CqnSelectListValue build() {
        if (this.value.isRef()) {
            return new CqnSelectListRefImpl(this.value.asRef());
        }
        return new CqnSelectListValueImpl(this.value, this.alias);
    }

    private static class CqnSelectListValueImpl
    implements CqnSelectListValue {
        private final CqnValue value;
        private final String alias;

        private CqnSelectListValueImpl(CqnValue value, String alias) {
            this.value = value;
            this.alias = alias;
        }

        public CqnValue value() {
            return this.value;
        }

        public String displayName() {
            return this.alias;
        }

        public Optional<String> alias() {
            return Optional.ofNullable(this.alias);
        }

        public String toJson() {
            if (this.alias != null) {
                Jsonizer object = this.value instanceof CqnPlain ? Jsonizer.object("xpr", new CqnValue[]{this.value}) : Jsonizer.object((JSONizable)this.value);
                return object.put("as", this.alias).toJson();
            }
            return this.value.toJson();
        }

        public String toString() {
            return this.toJson();
        }
    }

    private static class CqnSelectListRefImpl
    implements CqnSelectListValue {
        private final CqnElementRef ref;

        private CqnSelectListRefImpl(CqnElementRef ref) {
            this.ref = ref;
        }

        public CqnValue value() {
            return this.ref;
        }

        public String displayName() {
            return this.ref.displayName();
        }

        public Optional<String> alias() {
            return this.ref.alias();
        }

        public String toJson() {
            return this.ref.toJson();
        }

        public String toString() {
            return this.ref.toJson();
        }
    }
}

