/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.ql.impl;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.sap.cds.impl.builder.model.StructuredTypeImpl;
import com.sap.cds.impl.builder.model.StructuredTypeRefImpl;
import com.sap.cds.impl.parser.token.AbstractJSONizable;
import com.sap.cds.impl.parser.token.Jsonizer;
import com.sap.cds.ql.Insert;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.StructuredTypeRef;
import com.sap.cds.ql.Upsert;
import com.sap.cds.ql.cqn.CqnInsert;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnUpsert;
import com.sap.cds.ql.cqn.CqnXsert;
import com.sap.cds.ql.cqn.Modifier;
import com.sap.cds.ql.impl.ExpressionVisitor;
import com.sap.cds.util.DataUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Stream;

public class XsertBuilder
extends AbstractJSONizable {
    private final CqnXsert.Kind kind;
    private final StructuredType<?> entity;
    private final List<Map<String, Object>> entries = new ArrayList<Map<String, Object>>();

    private XsertBuilder(CqnXsert.Kind kind, StructuredType<?> entity) {
        this.kind = kind;
        this.entity = entity;
    }

    public static Insert insert(CqnStructuredTypeRef ref) {
        return new InsertBuilder(StructuredTypeImpl.structuredType(ref));
    }

    public static Insert insert(StructuredType<?> entity) {
        return new InsertBuilder(entity);
    }

    public static Upsert upsert(CqnStructuredTypeRef ref) {
        return new UpsertBuilder(StructuredTypeImpl.structuredType(ref), true);
    }

    public static Upsert upsert(StructuredType<?> entity) {
        return new UpsertBuilder(entity, true);
    }

    public static Insert copy(CqnInsert insert) {
        return XsertBuilder.copy(insert, ExpressionVisitor.COPY);
    }

    public static Insert copy(CqnInsert insert, Modifier modifier) {
        StructuredTypeRef ref = ExpressionVisitor.copy(insert.ref(), modifier);
        return XsertBuilder.insert((CqnStructuredTypeRef)ref).entries((Iterable)insert.entries());
    }

    public static Upsert copy(CqnUpsert upsert) {
        return XsertBuilder.copy(upsert, ExpressionVisitor.COPY);
    }

    public static Upsert copy(CqnUpsert upsert, Modifier modifier) {
        StructuredTypeRef ref = ExpressionVisitor.copy(upsert.ref(), modifier);
        return XsertBuilder.upsert((CqnStructuredTypeRef)ref).entries((Iterable)upsert.entries());
    }

    public XsertBuilder setEntries(Iterable<? extends Map<String, ?>> entries) {
        this.entries.clear();
        entries.forEach(this::addEntry);
        return this;
    }

    protected XsertBuilder addEntry(String key, Object value) {
        this.addEntry(Collections.singletonMap(key, value));
        return this;
    }

    protected XsertBuilder addEntry(Map<String, ?> entry) {
        this.entries.add(DataUtils.copyMap(entry));
        return this;
    }

    public CqnStructuredTypeRef ref() {
        return StructuredTypeRefImpl.typeRef(this.entity);
    }

    public List<Map<String, Object>> entries() {
        return this.entries;
    }

    public Stream<String> elements() {
        TreeSet all = new TreeSet();
        for (Map<String, Object> map : this.entries) {
            DataUtils.deepMapKeys(map).forEach(all::add);
        }
        return all.stream();
    }

    public String toJson() {
        Jsonizer cqn = Jsonizer.object("into", this.entity);
        ArrayNode data = cqn.array("entries");
        this.entries.forEach(arg_0 -> ((ArrayNode)data).addPOJO(arg_0));
        return Jsonizer.object(this.kind.name(), cqn).toJson();
    }

    public static class UpsertBuilder
    extends XsertBuilder
    implements Upsert {
        private final boolean deleteAndInsert;

        public UpsertBuilder(StructuredType<?> type, boolean deleteAndInsert) {
            super(CqnXsert.Kind.UPSERT, type);
            this.deleteAndInsert = deleteAndInsert;
        }

        public static Upsert upsert(StructuredType<?> entity) {
            return new UpsertBuilder(entity, false);
        }

        public Upsert entries(Iterable<? extends Map<String, ?>> entries) {
            this.setEntries(entries);
            return this;
        }

        public Upsert entry(Map<String, ?> entry) {
            this.addEntry(entry);
            return this;
        }

        public Upsert entry(String key, Object value) {
            this.addEntry(key, value);
            return this;
        }

        public boolean byDeleteAndInsert() {
            return this.deleteAndInsert;
        }
    }

    private static class InsertBuilder
    extends XsertBuilder
    implements Insert {
        public InsertBuilder(StructuredType<?> type) {
            super(CqnXsert.Kind.INSERT, type);
        }

        public Insert entries(Iterable<? extends Map<String, ?>> entries) {
            this.setEntries(entries);
            return this;
        }

        public Insert entry(Map<String, ?> entry) {
            this.addEntry(entry);
            return this;
        }

        public Insert entry(String key, Object value) {
            this.addEntry(key, value);
            return this;
        }
    }
}

