/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.reflect.impl;

import com.sap.cds.reflect.CdsAction;
import com.sap.cds.reflect.CdsAnnotation;
import com.sap.cds.reflect.CdsParameter;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.reflect.impl.CdsDefinitionBuilder;
import com.sap.cds.reflect.impl.CdsDefinitionImpl;
import com.sap.cds.reflect.impl.CdsParameterBuilder;
import com.sap.cds.reflect.impl.CdsTypeBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public class CdsActionBuilder
extends CdsDefinitionBuilder<CdsAction> {
    private final List<CdsParameterBuilder> parameters = new ArrayList<CdsParameterBuilder>();
    private final String doc;
    private CdsTypeBuilder<?> returnType = null;
    private CdsActionImpl impl = null;

    public CdsActionBuilder(List<CdsAnnotation<?>> annotations, String qualifiedName, String name, String doc) {
        super(annotations, qualifiedName, name);
        this.doc = doc;
    }

    @Override
    public CdsAction build() {
        if (this.impl == null) {
            this.impl = new CdsActionImpl(this.annotations, this.qualifiedName, this.getName(), this.doc);
            this.parameters.stream().filter(pb -> !pb.toBeIgnored(this.qualifiedName + "." + pb.getName())).forEach(p -> this.impl.parameters.add(p.build()));
            if (this.returnType != null) {
                this.impl.returnType = (CdsType)this.returnType.build();
            }
        }
        return this.impl;
    }

    void addParameter(CdsParameterBuilder p) {
        this.parameters.add(p);
    }

    void addParameters(List<CdsParameterBuilder> params) {
        params.forEach(this::addParameter);
    }

    void setReturnType(CdsTypeBuilder<?> returnType) {
        this.returnType = returnType;
    }

    private static class CdsActionImpl
    extends CdsDefinitionImpl
    implements CdsAction {
        private final List<CdsParameter> parameters = new ArrayList<CdsParameter>();
        private CdsType returnType;

        private CdsActionImpl(Collection<CdsAnnotation<?>> annotations, String qualifiedName, String name, String doc) {
            super(annotations, qualifiedName, name, doc);
        }

        public Stream<CdsParameter> parameters() {
            return this.parameters.stream();
        }

        public Optional<CdsType> returnType() {
            return Optional.ofNullable(this.returnType);
        }
    }
}

