/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.reflect.impl;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.sap.cds.reflect.CdsAnnotation;
import com.sap.cds.reflect.impl.CdsAnnotatableImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CdsAnnotationReader {
    private static final ObjectMapper jackson = new ObjectMapper();
    private static final JavaType UNKNOWN_TYPE = TypeFactory.unknownType();

    private CdsAnnotationReader() {
    }

    public static List<CdsAnnotation<?>> read(JsonNode jsonObject) {
        ArrayList list = new ArrayList();
        Iterator fields = jsonObject.fields();
        while (fields.hasNext()) {
            Object val;
            String name = (String)((Map.Entry)fields.next()).getKey();
            if (!CdsAnnotationReader.isAnnotation(name)) continue;
            JsonNode value = jsonObject.get(name);
            try {
                val = jackson.readValue(value.toString(), UNKNOWN_TYPE);
            }
            catch (IOException e) {
                val = value.toString();
            }
            if (val == null) continue;
            list.add(CdsAnnotatableImpl.CdsAnnotationImpl.annotation(name, val));
        }
        return list;
    }

    public static boolean isAnnotation(String key) {
        return key.startsWith("@");
    }
}

