/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.reflect.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.sap.cds.impl.parser.ExpressionParser;
import com.sap.cds.impl.parser.TokenParser;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.impl.CdsAnnotationReader;
import com.sap.cds.reflect.impl.CdsAssociationTypeBuilder;
import com.sap.cds.reflect.impl.CdsEntityBuilder;
import com.sap.cds.reflect.impl.CdsModelBuilder;
import com.sap.cds.reflect.impl.CdsModelReader;
import com.sap.cds.reflect.impl.CdsTypeBuilder;
import com.sap.cds.reflect.impl.reader.issuecollector.IssueCollector;
import com.sap.cds.reflect.impl.reader.issuecollector.IssueCollectorFactory;
import com.sap.cds.util.StructuredTypeResolver;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;

public class CdsAssociationReader {
    private static final IssueCollector issueCollector = IssueCollectorFactory.getIssueCollector(CdsAssociationReader.class);
    private final CdsModelBuilder model;
    private final StructuredTypeResolver structResolver;

    public CdsAssociationReader(CdsModelBuilder model, StructuredTypeResolver structResolver) {
        this.model = model;
        this.structResolver = structResolver;
    }

    public CdsTypeBuilder<? extends CdsAssociationType> read(String path, JsonNode csn) {
        Iterator fields = csn.fields();
        boolean isComposition = false;
        CdsEntityBuilder target = null;
        CdsTypeBuilder<?> targetAspect = null;
        CqnPredicate on = null;
        CdsAssociationType.Cardinality cardinality = null;
        LinkedHashSet<CqnElementRef> keyElements = new LinkedHashSet<CqnElementRef>();
        block20: while (fields.hasNext()) {
            String elementName = (String)((Map.Entry)fields.next()).getKey();
            if (CdsAnnotationReader.isAnnotation(elementName)) continue;
            JsonNode elementValue = csn.get(elementName);
            switch (elementName) {
                case "type": {
                    isComposition = elementValue.asText().equals("cds.Composition");
                    break;
                }
                case "target": {
                    target = this.model.getEntity(elementValue.asText());
                    break;
                }
                case "targetAspect": {
                    if (elementValue.has("elements")) {
                        targetAspect = this.readTargetAspect(path, elementValue);
                        break;
                    }
                    targetAspect = this.model.getAspect(elementValue.asText());
                    break;
                }
                case "cardinality": {
                    cardinality = CdsAssociationReader.readCardinality(path, csn.get(elementName), isComposition);
                    break;
                }
                case "on": {
                    on = ExpressionParser.parsePredicate(elementValue.toString());
                    break;
                }
                case "kind": 
                case "keys": {
                    for (JsonNode n : elementValue) {
                        CqnElementRef ref = TokenParser.elementRef(n);
                        keyElements.add(ref);
                        if (ref.segments().size() <= 1) continue;
                        issueCollector.unsupported(path, "The association '%s' has a path as key '%s'.", path, ref);
                    }
                    continue block20;
                }
                case "key": 
                case "notNull": {
                    break;
                }
                default: {
                    issueCollector.unrecognized(path, "The association '%s' contains an unrecognized property '%s'.", path, elementName);
                }
            }
        }
        if (cardinality == null) {
            String srcMax = isComposition ? "1" : "*";
            cardinality = CdsAssociationTypeBuilder.CardinalityImpl.create(srcMax, "0", "1");
        }
        if (on != null) {
            return CdsAssociationTypeBuilder.unmanaged(CdsAnnotationReader.read(csn), target, cardinality, isComposition, on, targetAspect);
        }
        return CdsAssociationTypeBuilder.managed(CdsAnnotationReader.read(csn), target, keyElements, cardinality, isComposition, targetAspect);
    }

    private CdsTypeBuilder<?> readTargetAspect(String typeName, JsonNode elementValue) {
        ObjectNode modifiedJsonNode = ((ObjectNode)elementValue).put("kind", "aspect");
        return CdsModelReader.readType(typeName, (JsonNode)new ObjectMapper().convertValue((Object)modifiedJsonNode, JsonNode.class), this.model, this.structResolver);
    }

    private static CdsAssociationType.Cardinality readCardinality(String path, JsonNode csn, boolean isComposition) {
        String sourceMax = null;
        String targetMin = "0";
        String targetMax = "1";
        Iterator fields = csn.fields();
        block10: while (fields.hasNext()) {
            String property;
            switch (property = (String)((Map.Entry)fields.next()).getKey()) {
                case "max": {
                    targetMax = csn.get(property).asText();
                    continue block10;
                }
                case "src": {
                    sourceMax = csn.get(property).asText();
                    continue block10;
                }
                case "min": {
                    targetMin = csn.get(property).asText();
                    continue block10;
                }
            }
            issueCollector.unrecognized(path, "The association has a cardinality specification with an unrecognized property '%s'", property);
        }
        if (sourceMax == null) {
            sourceMax = isComposition || targetMax.equals("*") ? "1" : "*";
        }
        return CdsAssociationTypeBuilder.CardinalityImpl.create(sourceMax, targetMin, targetMax);
    }
}

