/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.reflect.impl;

import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.reflect.CdsAnnotation;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsKind;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.reflect.impl.CdsAnnotatableImpl;
import com.sap.cds.reflect.impl.CdsEntityBuilder;
import com.sap.cds.reflect.impl.CdsTypeBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public class CdsAssociationTypeBuilder
extends CdsTypeBuilder<CdsAssociationType> {
    private final CdsEntityBuilder target;
    private final CdsTypeBuilder<?> targetAspect;
    private final CdsAssociationType.Cardinality cardinality;
    private final boolean isComposition;
    private final Set<CqnElementRef> keyElements;
    private final Optional<CqnPredicate> onCondition;
    private CdsAssociationType impl = null;

    private CdsAssociationTypeBuilder(List<CdsAnnotation<?>> annotations, CdsEntityBuilder target, Set<CqnElementRef> keyElements, CdsAssociationType.Cardinality cardinality, boolean isComposition, CqnPredicate onCondition, CdsTypeBuilder<?> targetAspect) {
        super(annotations, null, "");
        this.target = target;
        this.cardinality = cardinality;
        this.isComposition = isComposition;
        this.onCondition = Optional.ofNullable(onCondition);
        this.keyElements = keyElements;
        this.targetAspect = targetAspect;
    }

    public static CdsAssociationTypeBuilder managed(List<CdsAnnotation<?>> annotations, CdsEntityBuilder target, Set<CqnElementRef> keys, CdsAssociationType.Cardinality cardinality, boolean isComposition, CdsTypeBuilder<?> targetAspect) {
        return new CdsAssociationTypeBuilder(annotations, target, keys, cardinality, isComposition, null, targetAspect);
    }

    public static CdsAssociationTypeBuilder unmanaged(List<CdsAnnotation<?>> annotations, CdsEntityBuilder target, CdsAssociationType.Cardinality cardinality, boolean isComposition, CqnPredicate onCondition, CdsTypeBuilder<?> targetAspect) {
        return new CdsAssociationTypeBuilder(annotations, target, Collections.emptySet(), cardinality, isComposition, onCondition, targetAspect);
    }

    @Override
    public String getQualifiedName() {
        return null;
    }

    @Override
    public CdsAssociationType build() {
        if (this.impl == null) {
            CqnPredicate newOnCondition = null;
            if (this.onCondition.isPresent()) {
                newOnCondition = this.onCondition.get();
            }
            this.impl = new CdsAssociationTypeImpl(this.annotations, this.cardinality, this.isComposition, newOnCondition, this.keyElements);
            if (this.target != null) {
                ((CdsAssociationTypeImpl)this.impl).setTarget(this.target.build());
            }
            if (this.targetAspect != null) {
                ((CdsAssociationTypeImpl)this.impl).setTargetAspect((CdsType)this.targetAspect.build());
            }
        }
        return this.impl;
    }

    @Override
    public boolean isArrayed() {
        return false;
    }

    @Override
    public boolean isStructured() {
        return false;
    }

    private static class CdsAssociationTypeImpl
    extends CdsAnnotatableImpl
    implements CdsAssociationType {
        private final CdsAssociationType.Cardinality cardinality;
        private final boolean isComposition;
        private final Optional<CqnPredicate> onCondition;
        private final Set<CqnElementRef> keyElements = new LinkedHashSet<CqnElementRef>();
        private CdsEntity target;
        private CdsType targetAspect;

        private CdsAssociationTypeImpl(Collection<CdsAnnotation<?>> annotations, CdsAssociationType.Cardinality cardinality, boolean isComposition, CqnPredicate onCondition, Set<CqnElementRef> keyElements) {
            super(annotations, null);
            this.cardinality = cardinality;
            this.isComposition = isComposition;
            this.onCondition = Optional.ofNullable(onCondition);
            this.keyElements.addAll(keyElements);
        }

        public CdsEntity getTarget() {
            return this.target;
        }

        private void setTarget(CdsEntity target) {
            this.target = target;
        }

        public Optional<CdsType> getTargetAspect() {
            return Optional.ofNullable(this.targetAspect);
        }

        private void setTargetAspect(CdsType target) {
            this.targetAspect = target;
        }

        public CdsAssociationType.Cardinality getCardinality() {
            return this.cardinality;
        }

        public boolean isComposition() {
            return this.isComposition;
        }

        public Stream<CqnElementRef> refs() {
            return this.keyElements.stream();
        }

        public Stream<CdsElement> keys() {
            return this.refs().map(this::element);
        }

        private CdsElement element(CqnElementRef ref) {
            if (ref.segments().size() == 1) {
                return this.target.getElement(ref.firstSegment());
            }
            throw new UnsupportedOperationException("Key reference with more than one segment: " + ref);
        }

        public Optional<CqnPredicate> onCondition() {
            return this.onCondition;
        }

        public CdsKind getKind() {
            return CdsKind.TYPE;
        }

        public String getName() {
            return null;
        }

        public String getQualifier() {
            return "cds.Association";
        }
    }

    public static class CardinalityImpl
    implements CdsAssociationType.Cardinality {
        private final String sourceMax;
        private final String targetMin;
        private final String targetMax;

        CardinalityImpl(String sourceMax, String targetMin, String targetMax) {
            this.sourceMax = sourceMax;
            this.targetMin = targetMin;
            this.targetMax = targetMax;
        }

        public static CdsAssociationType.Cardinality create(String sourceMax, String targetMin, String targetMax) {
            return new CardinalityImpl(sourceMax, targetMin, targetMax);
        }

        public String getSourceMax() {
            return this.sourceMax;
        }

        public String getTargetMin() {
            return this.targetMin;
        }

        public String getTargetMax() {
            return this.targetMax;
        }
    }
}

