/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.reflect.impl;

import com.sap.cds.reflect.CdsAnnotation;
import com.sap.cds.reflect.CdsDefinition;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.impl.CdsAnnotableBuilder;
import java.util.List;
import java.util.function.Predicate;

public abstract class CdsDefinitionBuilder<T extends CdsDefinition>
extends CdsAnnotableBuilder<T> {
    protected final String qualifiedName;
    protected final String name;

    public CdsDefinitionBuilder(List<CdsAnnotation<?>> annotations, String qualifiedName, String name) {
        super(annotations);
        this.qualifiedName = qualifiedName;
        this.name = name;
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public String getName() {
        if (this.name == null || this.name.isEmpty()) {
            String qualifiedName = this.getQualifiedName();
            int lastDotPos = qualifiedName.lastIndexOf(46);
            if (lastDotPos >= 0 && lastDotPos + 1 < qualifiedName.length()) {
                return qualifiedName.substring(lastDotPos + 1);
            }
            return qualifiedName;
        }
        return this.name;
    }

    static Predicate<CdsDefinitionBuilder<?>> byNamespace(String namespace) {
        if (namespace == null || namespace.isEmpty()) {
            return d -> true;
        }
        return d -> d.getQualifiedName().startsWith(namespace + ".");
    }

    public abstract T build();

    public T build(CdsModel model) {
        throw new UnsupportedOperationException();
    }
}

