/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.reflect.impl;

import com.sap.cds.reflect.CdsAnnotation;
import com.sap.cds.reflect.CdsDefinition;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.reflect.impl.CdsAnnotableBuilder;
import com.sap.cds.reflect.impl.CdsAnnotatableImpl;
import com.sap.cds.reflect.impl.CdsDefinitionBuilder;
import com.sap.cds.reflect.impl.CdsTypeBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class CdsElementBuilder<T extends CdsType>
extends CdsAnnotableBuilder<CdsElement> {
    private String name;
    private final CdsTypeBuilder<T> typeBuilder;
    private T type;
    private boolean isKey;
    private final boolean isVirtual;
    private final boolean isNotNull;
    private final boolean isLocalized;
    private final Object defaultValue;
    private final String doc;
    private CdsDefinitionBuilder<?> declaringType;

    public CdsTypeBuilder<T> getTypeBuilder() {
        return this.typeBuilder;
    }

    public CdsElementBuilder(List<CdsAnnotation<?>> annotations, String name, CdsTypeBuilder<T> typeBuilder, boolean isKey, boolean isVirtual, boolean isNotNull, boolean isLocalized, Object defaultValue, String doc) {
        super(annotations);
        this.name = name;
        this.typeBuilder = typeBuilder;
        this.isKey = isKey;
        this.isVirtual = isVirtual;
        this.isNotNull = isNotNull;
        this.isLocalized = isLocalized;
        this.defaultValue = defaultValue;
        this.doc = doc;
    }

    public static <T extends CdsType> CdsElementBuilder<T> element(String name) {
        return new CdsElementBuilder<T>(Collections.emptyList(), name, null, false, false, false, false, null, null);
    }

    public static CdsElementBuilder<?> copy(CdsElement element) {
        List<CdsAnnotation<?>> annotations = element.annotations().collect(Collectors.toList());
        String doc = null;
        Optional<String> elementDoc = ((CdsAnnotatableImpl)element).getDoc();
        if (elementDoc.isPresent()) {
            doc = elementDoc.get();
        }
        return new CdsElementBuilder<CdsType>(annotations, element.getName(), null, element.isKey(), element.isVirtual(), element.isNotNull(), element.isLocalized(), element.defaultValue().orElse(null), doc).type(element.getType());
    }

    public CdsElementBuilder<T> name(String name) {
        this.name = name;
        return this;
    }

    public CdsElementBuilder<T> isKey(boolean isKey) {
        this.isKey = isKey;
        return this;
    }

    public CdsElementBuilder<T> type(T type) {
        this.type = type;
        return this;
    }

    public String getName() {
        return this.name;
    }

    void setDeclaringType(CdsDefinitionBuilder<?> declaringType) {
        if (this.declaringType == null) {
            this.declaringType = declaringType;
        }
    }

    public CdsElement build(CdsDefinition declarator) {
        if (this.type == null) {
            this.type = (CdsType)this.typeBuilder.build();
        }
        return new CdsElementImpl(this, (Collection)this.annotations, this.name, this.type, this.isKey, this.isVirtual, this.isNotNull, this.isLocalized, declarator, this.defaultValue, this.doc);
    }

    static class CdsElementImpl
    extends CdsAnnotatableImpl
    implements CdsElement {
        private final String name;
        private final T type;
        private final boolean isKey;
        private final boolean isVirtual;
        private final boolean isNotNull;
        private final boolean isLocalized;
        private final Object defaultValue;
        private final CdsDefinition declarator;
        final /* synthetic */ CdsElementBuilder this$0;

        public CdsElementImpl(Collection<CdsAnnotation<?>> annotations, String name, T type, boolean isKey, boolean isVirtual, boolean isNotNull, boolean isLocalized, CdsDefinition declarator, Object defaultValue, String doc) {
            this.this$0 = this$0;
            super(annotations, doc);
            this.name = name;
            this.type = type;
            this.isKey = isKey;
            this.isVirtual = isVirtual;
            this.isNotNull = isNotNull;
            this.isLocalized = isLocalized;
            this.defaultValue = defaultValue;
            this.declarator = declarator;
        }

        public String getName() {
            return this.name;
        }

        public <D extends CdsDefinition> D getDeclaringType() {
            return (D)this.declarator;
        }

        public T getType() {
            return this.type;
        }

        public boolean isKey() {
            return this.isKey;
        }

        public boolean isVirtual() {
            return this.isVirtual;
        }

        public boolean isUnique() {
            throw new UnsupportedOperationException();
        }

        public boolean isNotNull() {
            return this.isNotNull;
        }

        public boolean isLocalized() {
            return this.isLocalized;
        }

        public Optional<Object> defaultValue() {
            return Optional.ofNullable(this.defaultValue);
        }

        public String toString() {
            return this.name;
        }
    }
}

