/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.reflect.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.sap.cds.reflect.impl.CdsAnnotationReader;
import com.sap.cds.reflect.impl.CdsElementBuilder;
import com.sap.cds.reflect.impl.CdsModelBuilder;
import com.sap.cds.reflect.impl.CdsModelReader;
import com.sap.cds.reflect.impl.CdsSimpleTypeReader;
import com.sap.cds.reflect.impl.CdsTypeBuilder;
import com.sap.cds.reflect.impl.reader.issuecollector.IssueCollector;
import com.sap.cds.reflect.impl.reader.issuecollector.IssueCollectorFactory;
import com.sap.cds.util.StructuredTypeResolver;
import java.util.Iterator;
import java.util.Map;

public class CdsElementReader {
    private static final IssueCollector issueCollector = IssueCollectorFactory.getIssueCollector(CdsElementReader.class);
    private final String pathToElement;
    private final String elementName;
    private final CdsModelBuilder model;
    private final boolean readDocs;

    public CdsElementReader(String pathToElement, String elementName, CdsModelBuilder model, boolean readDocComments) {
        this.pathToElement = pathToElement;
        this.elementName = elementName;
        this.model = model;
        this.readDocs = readDocComments;
    }

    public CdsElementBuilder<?> read(JsonNode csn, StructuredTypeResolver structResolver) {
        JsonNode defaultVal = ((ObjectNode)csn).remove("default");
        Object defaultValue = CdsSimpleTypeReader.defaultValue(defaultVal);
        CdsTypeBuilder type = CdsModelReader.findType(csn, this.model).orElseGet(() -> CdsModelReader.readType(this.pathToElement, csn, this.model, structResolver));
        Iterator fields = csn.fields();
        boolean isKey = false;
        boolean isVirtual = false;
        boolean isLocalized = false;
        boolean notNull = false;
        String doc = null;
        block33: while (fields.hasNext()) {
            String property = (String)((Map.Entry)fields.next()).getKey();
            if (CdsAnnotationReader.isAnnotation(property)) continue;
            switch (property) {
                case "items": 
                case "type": 
                case "length": 
                case "precision": 
                case "scale": 
                case "origin": 
                case "enum": 
                case "cds.localized": 
                case "elements": 
                case "indexNo": 
                case "$inferred": 
                case "value": 
                case "on": 
                case "target": 
                case "targetAspect": 
                case "cardinality": {
                    continue block33;
                }
                case "localized": {
                    isLocalized = csn.get(property).asBoolean();
                    continue block33;
                }
                case "keys": {
                    continue block33;
                }
                case "key": {
                    isKey = csn.get(property).asBoolean();
                    continue block33;
                }
                case "virtual": {
                    isVirtual = csn.get(property).asBoolean();
                    continue block33;
                }
                case "notNull": {
                    notNull = csn.get(property).asBoolean();
                    continue block33;
                }
                case "doc": {
                    if (!this.readDocs) continue block33;
                    doc = csn.get(property).asText();
                    continue block33;
                }
            }
            issueCollector.unrecognized(this.pathToElement, "The element '%s' contains an unrecognized property '%s'.", this.pathToElement, property);
        }
        return new CdsElementBuilder(CdsAnnotationReader.read(csn), this.elementName, type, isKey, isVirtual, notNull, isLocalized, defaultValue, doc);
    }
}

