/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.reflect.impl;

import com.sap.cds.impl.localized.LocaleUtils;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.reflect.CdsAction;
import com.sap.cds.reflect.CdsAnnotation;
import com.sap.cds.reflect.CdsDefinition;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsFunction;
import com.sap.cds.reflect.CdsKind;
import com.sap.cds.reflect.CdsOperationNotFoundException;
import com.sap.cds.reflect.CdsParameter;
import com.sap.cds.reflect.impl.CdsActionBuilder;
import com.sap.cds.reflect.impl.CdsFunctionBuilder;
import com.sap.cds.reflect.impl.CdsStructuredTypeBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdsEntityBuilder
extends CdsStructuredTypeBuilder<CdsEntity> {
    private static final Logger logger = LoggerFactory.getLogger(CdsEntityBuilder.class);
    private final boolean isAbstract;
    private final boolean isView;
    private final CqnSelect query;
    private final String name;
    private final String doc;
    private final Map<String, CdsActionBuilder> actions = new HashMap<String, CdsActionBuilder>();
    private final Map<String, CdsFunctionBuilder> functions = new HashMap<String, CdsFunctionBuilder>();
    private final List<CdsParameter> params = new ArrayList<CdsParameter>();
    private CdsEntityImpl impl;

    private CdsEntityBuilder(List<CdsAnnotation<?>> annotations, String name, String qualifiedName, boolean isAbstract, CqnSelect query, boolean isView, String doc) {
        super(annotations, qualifiedName, name, CdsKind.ENTITY, doc);
        this.isAbstract = isAbstract;
        this.query = query;
        this.isView = isView;
        this.name = name;
        this.doc = doc;
    }

    public static CdsEntityBuilder create(String name, String qualifiedName, List<CdsAnnotation<?>> annotations, boolean isAbstract, String query, String doc) {
        boolean isView;
        Select select = null;
        boolean bl = isView = query != null;
        if (isView) {
            try {
                select = Select.cqn((String)query);
            }
            catch (RuntimeException e) {
                logger.warn(String.format("The view %s has an unrecognized query definition: %s - Detailed error message: %s", qualifiedName, query, e));
            }
        }
        return new CdsEntityBuilder(annotations, name, qualifiedName, isAbstract, (CqnSelect)select, isView, doc);
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public Stream<CdsActionBuilder> actions() {
        return this.actions.values().stream();
    }

    void addAction(CdsActionBuilder action) {
        this.actions.put(action.getName(), action);
    }

    void addActions(List<CdsActionBuilder> actions) {
        actions.forEach(this::addAction);
    }

    public Stream<CdsFunctionBuilder> functions() {
        return this.functions.values().stream();
    }

    void addFunction(CdsFunctionBuilder function) {
        this.functions.put(function.getName(), function);
    }

    void addFunctions(List<CdsFunctionBuilder> functions) {
        functions.forEach(this::addFunction);
    }

    void addParams(List<CdsParameter> params) {
        this.params.addAll(params);
    }

    @Override
    public CdsEntity build() {
        if (this.impl == null) {
            this.impl = new CdsEntityImpl(this.annotations, this.name, this.qualifiedName, this.isAbstract(), this.query, this.params, this.isView, this.doc);
            this.putElements(this.impl);
            this.actions.forEach((n, ab) -> this.impl.actions.put(ab.getName(), ab.build()));
            this.functions.forEach((n, fb) -> this.impl.functions.put(fb.getName(), fb.build()));
        }
        return this.impl;
    }

    @Override
    boolean toBeIgnored(String path) {
        return super.toBeIgnored(path) || LocaleUtils.isLocalizedEntityName(path);
    }

    private static class CdsEntityImpl
    extends CdsStructuredTypeBuilder.CdsStructuredTypeImpl
    implements CdsEntity {
        private final boolean isAbstract;
        private final boolean isView;
        private final CqnSelect query;
        private final List<CdsParameter> params;
        private final Map<String, CdsAction> actions = new HashMap<String, CdsAction>();
        private final Map<String, CdsFunction> functions = new HashMap<String, CdsFunction>();

        private CdsEntityImpl(Collection<CdsAnnotation<?>> annotations, String name, String qualifiedName, boolean isAbstract, CqnSelect query, List<CdsParameter> params, boolean isView, String doc) {
            super(annotations, qualifiedName, name, doc);
            this.isAbstract = isAbstract;
            this.query = query;
            this.params = params;
            this.isView = isView;
        }

        public boolean isAbstract() {
            return this.isAbstract;
        }

        public boolean isView() {
            return this.isView;
        }

        public boolean isProjection() {
            throw new UnsupportedOperationException();
        }

        public Optional<CqnSelect> query() {
            return Optional.ofNullable(this.query);
        }

        public Stream<CdsParameter> params() {
            return this.params.stream();
        }

        public Stream<CdsAction> actions() {
            return this.actions.values().stream();
        }

        public CdsAction getAction(String name) {
            return this.findAction(name).orElseThrow(() -> new CdsOperationNotFoundException(CdsKind.ACTION, name, (CdsDefinition)this));
        }

        public Optional<CdsAction> findAction(String name) {
            return Optional.ofNullable(this.actions.get(name));
        }

        public Stream<CdsFunction> functions() {
            return this.functions.values().stream();
        }

        public CdsFunction getFunction(String name) {
            return this.findFunction(name).orElseThrow(() -> new CdsOperationNotFoundException(CdsKind.FUNCTION, name, (CdsDefinition)this));
        }

        public Optional<CdsFunction> findFunction(String name) {
            return Optional.ofNullable(this.functions.get(name));
        }
    }
}

