/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.reflect.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.sap.cds.impl.parser.TokenParser;
import com.sap.cds.reflect.CdsAnnotation;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsEnumType;
import com.sap.cds.reflect.impl.CdsAnnotatableImpl;
import com.sap.cds.reflect.impl.CdsAnnotationReader;
import com.sap.cds.reflect.impl.CdsSimpleTypeBuilder;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CdsEnumTypeBuilder<T>
extends CdsSimpleTypeBuilder {
    private Map<String, JsonNode> values;

    public CdsEnumTypeBuilder(List<CdsAnnotation<?>> annotations, String qualifiedName, String name, CdsBaseType cdsType, Map<String, Object> properties, Map<String, JsonNode> values) {
        super(annotations, qualifiedName, name, cdsType, properties);
        this.values = values;
    }

    @Override
    public CdsEnumType<T> build() {
        return new CdsEnumTypeImpl(this.annotations, this.qualifiedName, this.getName(), this.cdsType, this.properties, this.values);
    }

    private static class CdsEnumTypeImpl<T>
    extends CdsSimpleTypeBuilder.CdsSimpleTypeImpl
    implements CdsEnumType<T> {
        private final Map<String, CdsEnumType.Enumeral<T>> values = new HashMap<String, CdsEnumType.Enumeral<T>>();

        private CdsEnumTypeImpl(Collection<CdsAnnotation<?>> annotations, String qualifiedName, String name, CdsBaseType cdsType, Map<String, Object> properties, Map<String, JsonNode> values) {
            super(annotations, qualifiedName, name, cdsType, properties);
            values.forEach((key, value) -> {
                CdsEnumType.Enumeral cfr_ignored_0 = this.values.put((String)key, new CdsEnumeralImpl(CdsAnnotationReader.read(value), (String)key, this.getVal((JsonNode)value, (String)key, cdsType)));
            });
        }

        private T getVal(JsonNode value, String defaultValue, CdsBaseType type) {
            JsonNode valNode = value.get("val");
            if (valNode != null) {
                return (T)TokenParser.value(valNode, type);
            }
            return (T)defaultValue;
        }

        public Map<String, CdsEnumType.Enumeral<T>> enumerals() {
            return this.values;
        }

        private class CdsEnumeralImpl
        extends CdsAnnotatableImpl
        implements CdsEnumType.Enumeral<T> {
            private final String name;
            private final T value;

            private CdsEnumeralImpl(List<CdsAnnotation<?>> annotations, String name, T value) {
                super(annotations, null);
                this.name = name;
                this.value = value;
            }

            public T value() {
                return this.value;
            }

            public String name() {
                return this.name;
            }
        }
    }
}

