/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.reflect.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsSimpleType;
import com.sap.cds.reflect.impl.CdsAnnotationReader;
import com.sap.cds.reflect.impl.CdsEnumTypeReader;
import com.sap.cds.reflect.impl.CdsSimpleTypeBuilder;
import com.sap.cds.reflect.impl.CdsTypeBuilder;
import com.sap.cds.reflect.impl.reader.issuecollector.IssueCollector;
import com.sap.cds.reflect.impl.reader.issuecollector.IssueCollectorFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class CdsSimpleTypeReader {
    private static final IssueCollector issueCollector = IssueCollectorFactory.getIssueCollector(CdsSimpleTypeReader.class);

    private CdsSimpleTypeReader() {
    }

    public static CdsTypeBuilder<CdsSimpleType> read(String qualifiedName, String name, JsonNode jsonType) {
        if (jsonType.has("items")) {
            JsonNode jsonNode = jsonType.get("items");
            return CdsSimpleTypeReader.read(qualifiedName, name, jsonNode);
        }
        Iterator fields = jsonType.fields();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        boolean isTypeDefinition = false;
        boolean isEnum = false;
        block33: while (fields.hasNext()) {
            String property = (String)((Map.Entry)fields.next()).getKey();
            JsonNode value = jsonType.get(property);
            switch (property) {
                case "type": 
                case "key": 
                case "virtual": 
                case "cardinality": 
                case "on": 
                case "value": 
                case "foreignKeys": 
                case "keys": 
                case "redirected": 
                case "origin": 
                case "notNull": 
                case "doc": 
                case "cds.localized": 
                case "localized": {
                    continue block33;
                }
                case "enum": {
                    isEnum = true;
                    continue block33;
                }
                case "$inferred": 
                case "target": {
                    continue block33;
                }
                case "length": 
                case "precision": 
                case "scale": 
                case "srid": {
                    properties.put(property, value.asInt());
                    continue block33;
                }
                case "kind": {
                    isTypeDefinition = value.asText().equals("type");
                    continue block33;
                }
                case "default": {
                    Object v = CdsSimpleTypeReader.defaultValue(value);
                    properties.put(property, v);
                    continue block33;
                }
            }
            if (CdsAnnotationReader.isAnnotation(property)) continue;
            issueCollector.unrecognized(qualifiedName, "The type '%s' contains an unrecognized property '%s'.", qualifiedName, property);
        }
        if (!jsonType.has("type")) {
            issueCollector.warning(qualifiedName, "Element is missing type. Please add the element type in the CDS model, this element is resolved to the Java type Object.", new Object[0]);
            return new CdsSimpleTypeBuilder(CdsAnnotationReader.read(jsonType), qualifiedName, name, null, properties);
        }
        String type = jsonType.get("type").asText();
        CdsBaseType baseType = CdsBaseType.cdsType((String)type);
        if (!isTypeDefinition) {
            qualifiedName = type;
        }
        if (isEnum) {
            return CdsEnumTypeReader.read(jsonType.get("enum"), CdsAnnotationReader.read(jsonType), qualifiedName, name, baseType, properties);
        }
        return new CdsSimpleTypeBuilder(CdsAnnotationReader.read(jsonType), qualifiedName, name, baseType, properties);
    }

    public static Object defaultValue(JsonNode value) {
        if (value == null) {
            return null;
        }
        if (value.has("val")) {
            JsonNode val = value.get("val");
            if (val.isNull()) {
                return null;
            }
            if (val.isBoolean()) {
                return val.asBoolean();
            }
            if (val.isNumber()) {
                return val.numberValue();
            }
            if (val.isTextual()) {
                return val.asText();
            }
        } else if (CdsSimpleTypeReader.isNow(value)) {
            return "$now";
        }
        throw CdsSimpleTypeReader.unexpectedDefault(value);
    }

    private static boolean isNow(JsonNode value) {
        String root;
        return value.has("ref") && "$now".equalsIgnoreCase(root = value.get("ref").get(0).asText());
    }

    private static RuntimeException unexpectedDefault(JsonNode value) {
        return new IllegalStateException("Unexpected default value: " + value.asText());
    }
}

