/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.reflect.impl;

import com.sap.cds.reflect.CdsAnnotation;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsDefinition;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsElementNotFoundException;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsKind;
import com.sap.cds.reflect.CdsReflectiveOperationException;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.reflect.impl.CdsDefinitionImpl;
import com.sap.cds.reflect.impl.CdsElementBuilder;
import com.sap.cds.reflect.impl.CdsTypeBuilder;
import com.sap.cds.util.CdsModelUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class CdsStructuredTypeBuilder<T extends CdsStructuredType>
extends CdsTypeBuilder<T> {
    protected final Map<String, CdsElementBuilder<?>> elements = new LinkedHashMap();
    protected final CdsKind kind;
    protected final String doc;
    private CdsStructuredTypeImpl impl;

    public CdsStructuredTypeBuilder(List<CdsAnnotation<?>> annotations, String qualifiedName, String name, CdsKind kind, String doc) {
        super(annotations, qualifiedName, name);
        this.kind = kind;
        this.doc = doc;
    }

    static Supplier<CdsElementNotFoundException> noSuchElement(String path, CdsDefinition context) {
        return () -> new CdsElementNotFoundException(path, context);
    }

    public void addElement(CdsElementBuilder<?> e) {
        this.elements.put(e.getName(), e);
    }

    public void addElements(List<CdsElementBuilder<?>> elements) {
        elements.forEach(this::addElement);
    }

    @Override
    public T build() {
        if (this.impl == null) {
            this.impl = new StructuredOrAspect(this.annotations, this.qualifiedName, this.getName(), this.kind, this.doc);
            this.putElements(this.impl);
        }
        return (T)this.impl;
    }

    protected void putElements(CdsStructuredTypeImpl st) {
        this.elements.values().stream().filter(e -> !e.toBeIgnored(st.getQualifiedName() + "." + e.getName())).forEach(eb -> CdsStructuredTypeBuilder.addElement(st, eb));
    }

    private static void addElement(CdsStructuredTypeImpl struct, CdsElementBuilder<?> eb) {
        String elementName = eb.getName();
        CdsElement element = eb.build(struct);
        struct.elements.put(elementName, element);
    }

    @Override
    public boolean isArrayed() {
        return false;
    }

    @Override
    public boolean isStructured() {
        return true;
    }

    public String toString() {
        return this.qualifiedName;
    }

    public CdsElementBuilder<?> putStructuredElementIfAbsent(String name, Function<String, CdsElementBuilder<?>> mappingFunction) {
        CdsElementBuilder<?> current = this.elements.get(name);
        if (current == null || current.getTypeBuilder() == null) {
            current = mappingFunction.apply(name);
            this.elements.put(name, current);
        }
        return current;
    }

    protected static abstract class CdsStructuredTypeImpl
    extends CdsDefinitionImpl
    implements CdsStructuredType {
        protected final Map<String, CdsElement> elements = new LinkedHashMap<String, CdsElement>();
        private final AtomicReference<Map<String, CdsElement>> fkElements = new AtomicReference();

        protected CdsStructuredTypeImpl(Collection<CdsAnnotation<?>> annotations, String qualifiedName, String name, String doc) {
            super(annotations, qualifiedName, name, doc);
        }

        public Stream<CdsElement> elements() {
            return this.elements.values().stream();
        }

        public Optional<CdsElement> findElement(String path) {
            CdsElement element = this.elements.get(path);
            if (element != null) {
                return Optional.of(element);
            }
            if (path.contains(".")) {
                return this.findElementByPath(path);
            }
            element = this.getFkElement(path);
            return Optional.ofNullable(element);
        }

        private Optional<CdsElement> findElementByPath(String path) {
            Optional element = Optional.empty();
            CdsStructuredTypeImpl type = this;
            for (String segment : path.split("\\.")) {
                CdsEntity struct;
                if (type.isAssociation()) {
                    struct = ((CdsAssociationType)type.as(CdsAssociationType.class)).getTarget();
                } else if (type.isStructured()) {
                    struct = (CdsStructuredType)type.as(CdsStructuredType.class);
                } else {
                    return Optional.empty();
                }
                element = struct.findElement(segment);
                if (!element.isPresent()) {
                    return element;
                }
                type = ((CdsElement)element.get()).getType();
            }
            return element;
        }

        private CdsElement getFkElement(String name) {
            Map<String, CdsElement> fks = this.fkElements.get();
            if (fks == null) {
                fks = this.calcFkElements();
                this.fkElements.compareAndSet(null, fks);
            }
            return fks.get(name);
        }

        private Map<String, CdsElement> calcFkElements() {
            HashMap<String, CdsElement> fkElements = new HashMap<String, CdsElement>();
            this.associations().filter(a -> CdsModelUtils.managedToOne(a.getType())).forEach(a -> CdsModelUtils.resolveManagedToOneAssociationMapping(a).forEach(keyPaths -> this.addFkElements(fkElements, (Map<CdsElement, List<String>>)keyPaths, a.isKey())));
            return fkElements;
        }

        private void addFkElements(Map<String, CdsElement> fkElements, Map<CdsElement, List<String>> keyPaths, boolean isKey) {
            keyPaths.forEach((element, path) -> {
                String fkName = String.join((CharSequence)"_", path);
                fkElements.put(fkName, CdsElementBuilder.copy(element).name(fkName).isKey(isKey).build(this));
            });
        }

        public CdsElement getElement(String name) {
            return this.findElement(name).orElseThrow(CdsStructuredTypeBuilder.noSuchElement(name, this));
        }

        public Optional<CdsElement> findAssociation(String name) {
            return this.findElement(name).filter(e -> e.getType().isAssociation());
        }

        public CdsElement getAssociation(String name) {
            return this.findAssociation(name).orElseThrow(CdsStructuredTypeBuilder.noSuchElement(name, this));
        }

        public <S extends CdsStructuredType> S getTargetOf(String path) {
            CdsElement element = this.findElementByPath(path).orElseThrow(CdsStructuredTypeBuilder.noSuchElement(path, this));
            CdsType type = element.getType();
            if (type.isAssociation()) {
                return (S)((CdsAssociationType)type.as(CdsAssociationType.class)).getTarget();
            }
            if (type.isStructured()) {
                return (S)((CdsStructuredType)type);
            }
            throw new CdsReflectiveOperationException("The element addressed by '" + path + "' must be structured or of type association");
        }
    }

    private static class StructuredOrAspect
    extends CdsStructuredTypeImpl {
        private final CdsKind kind;

        public StructuredOrAspect(List<CdsAnnotation<?>> annotations, String qualifiedName, String name, CdsKind kind, String doc) {
            super(annotations, qualifiedName, name, doc);
            this.kind = kind;
        }

        public CdsKind getKind() {
            return this.kind;
        }
    }
}

