/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.reflect.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.sap.cds.reflect.CdsKind;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.impl.CdsAnnotationReader;
import com.sap.cds.reflect.impl.CdsElementBuilder;
import com.sap.cds.reflect.impl.CdsElementReader;
import com.sap.cds.reflect.impl.CdsModelBuilder;
import com.sap.cds.reflect.impl.CdsStructuredTypeBuilder;
import com.sap.cds.reflect.impl.InvalidCsnException;
import com.sap.cds.reflect.impl.reader.issuecollector.IssueCollector;
import com.sap.cds.reflect.impl.reader.issuecollector.IssueCollectorFactory;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.StructuredTypeResolver;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdsStructuredTypeReader {
    private static final Logger logger = LoggerFactory.getLogger(CdsStructuredTypeReader.class);
    private static final IssueCollector issueCollector = IssueCollectorFactory.getIssueCollector(CdsStructuredTypeReader.class);
    private static final TextNode ASPECT = new TextNode("aspect");
    private static boolean readDocs = false;

    private CdsStructuredTypeReader() {
    }

    public static CdsStructuredTypeBuilder<CdsStructuredType> readWithoutElements(String qualifiedName, String name, JsonNode jsonStructuredType, boolean readDocComments) {
        readDocs = readDocComments;
        CdsKind kind = CdsKind.TYPE;
        if (jsonStructuredType.get("kind").asText().equals("aspect")) {
            kind = CdsKind.ASPECT;
        } else if (jsonStructuredType.has("$syntax")) {
            kind = jsonStructuredType.get("$syntax").asText().equals("aspect") ? CdsKind.ASPECT : CdsKind.TYPE;
        }
        CdsStructuredTypeBuilder<CdsStructuredType> struct = new CdsStructuredTypeBuilder<CdsStructuredType>(CdsAnnotationReader.read(jsonStructuredType), qualifiedName, name, kind, readDocs ? CdsModelUtils.getDoc(jsonStructuredType) : null);
        return struct;
    }

    public static CdsStructuredTypeBuilder<CdsStructuredType> read(String qualifiedName, JsonNode jsonStructuredType, CdsModelBuilder model, StructuredTypeResolver structResolver, boolean readDocComments) {
        readDocs = readDocComments;
        List<CdsElementBuilder<?>> elementList = CdsStructuredTypeReader.readElementList(qualifiedName, jsonStructuredType, model, structResolver);
        CdsKind kind = CdsKind.TYPE;
        if (ASPECT.equals((Object)jsonStructuredType.get("kind"))) {
            kind = CdsKind.ASPECT;
        }
        CdsStructuredTypeBuilder<CdsStructuredType> struct = new CdsStructuredTypeBuilder<CdsStructuredType>(CdsAnnotationReader.read(jsonStructuredType), qualifiedName, "", kind, readDocs ? CdsModelUtils.getDoc(jsonStructuredType) : null);
        struct.addElements(elementList);
        return struct;
    }

    public static List<CdsElementBuilder<?>> readElementList(String qualifiedName, JsonNode jsonStructuredType, CdsModelBuilder model, StructuredTypeResolver structResolver) {
        JsonNode jsonNode;
        LinkedList elementList = new LinkedList();
        if (jsonStructuredType.has("elements")) {
            jsonNode = jsonStructuredType.get("elements");
        } else if (jsonStructuredType.has("payload")) {
            jsonNode = jsonStructuredType.get("payload");
        } else {
            return elementList;
        }
        Iterator fields = jsonNode.fields();
        while (fields.hasNext()) {
            String elementName = (String)((Map.Entry)fields.next()).getKey();
            try {
                elementList.add(CdsStructuredTypeReader.readElement(qualifiedName, jsonNode, elementName, model, structResolver));
            }
            catch (InvalidCsnException e) {
                String pathToElement = qualifiedName + "." + elementName;
                logger.debug(qualifiedName + ": ", (Throwable)e);
                issueCollector.error(pathToElement, e.getMessage(), new Object[0]);
            }
        }
        return elementList;
    }

    private static CdsElementBuilder<?> readElement(String pathToType, JsonNode elementsObject, String elementName, CdsModelBuilder model, StructuredTypeResolver structResolver) {
        String pathToElement = pathToType.isEmpty() ? elementName : pathToType + "." + elementName;
        JsonNode jsonObject = elementsObject.get(elementName);
        return new CdsElementReader(pathToElement, elementName, model, readDocs).read(jsonObject, structResolver);
    }
}

