/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.reflect.impl;

public final class CdsVersion
implements Comparable<CdsVersion> {
    private int major;
    private int minor;
    private int micro;
    private int buildNumber;

    public CdsVersion(int major, int minor, int micro, int buildNumber) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.buildNumber = buildNumber;
    }

    public int major() {
        return this.major;
    }

    public int minor() {
        return this.minor;
    }

    public int micro() {
        return this.micro;
    }

    public int buildNumber() {
        return this.buildNumber;
    }

    @Override
    public int compareTo(CdsVersion other) {
        int[] me = new int[]{this.major, this.minor, this.micro, this.buildNumber};
        int[] another = new int[]{other.major, other.minor, other.micro, other.buildNumber};
        return this.compare(me, another);
    }

    private int compare(int[] me, int[] another) {
        for (int x = 0; x < me.length; ++x) {
            if (me[x] == another[x]) continue;
            return Integer.compare(me[x], another[x]);
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CdsVersion) {
            return this.compareTo((CdsVersion)obj) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.major << 12 + this.minor << 8 + this.micro << 4 + this.buildNumber;
    }
}

