/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.reflect.impl.reader.issuecollector;

import com.sap.cds.reflect.impl.reader.issuecollector.IssueType;

public class Issue {
    private final String location;
    private final String message;
    private final IssueType type;
    private final String reporter;

    public static Issue create(IssueType type, String location, String message, String reporter) {
        return new Issue(type, location, message, reporter);
    }

    private Issue(IssueType type, String location, String message, String reporter) {
        this.location = location;
        this.type = type;
        this.message = message;
        this.reporter = reporter;
    }

    public String getMessage() {
        return this.message;
    }

    public IssueType getType() {
        return this.type;
    }

    public String getLocation() {
        return this.location;
    }

    public String getReporter() {
        return this.reporter;
    }

    public String toString() {
        return this.location + ": " + this.message;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.reporter == null ? 0 : this.reporter.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Issue other = (Issue)obj;
        if (this.location == null ? other.location != null : !this.location.equals(other.location)) {
            return false;
        }
        if (this.message == null) {
            if (other.message != null) {
                return false;
            }
        } else {
            if (!this.message.equals(other.message)) {
                return false;
            }
            if (!this.reporter.equals(other.reporter)) {
                return false;
            }
        }
        return this.type == other.type;
    }
}

