/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.util;

import com.google.common.io.BaseEncoding;
import com.sap.cds.CdsException;
import com.sap.cds.ql.CdsDataException;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsType;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdsTypeUtils {
    private static final Logger logger = LoggerFactory.getLogger(CdsTypeUtils.class);
    private static final ZoneId ZULU = ZoneId.of("Z");
    private static final Map<CdsBaseType, Function<String, ?>> parsers = new EnumMap(CdsBaseType.class);
    private static final long NANOS_PER_SECOND = Duration.ofSeconds(1L).toNanos();
    private static final long SECONDS_PER_DAY = Duration.ofDays(1L).getSeconds();
    private static final int[] PWR_OF_TEN;

    public static Boolean parseBoolean(String input) {
        if (input == null) {
            return false;
        }
        return Boolean.parseBoolean(input = input.trim()) || "1".equals(input) || "X".equalsIgnoreCase(input);
    }

    private CdsTypeUtils() {
    }

    public static CdsBaseType cdsType(Class<?> javaType) {
        switch (javaType.getCanonicalName()) {
            case "java.lang.Boolean": {
                return CdsBaseType.BOOLEAN;
            }
            case "java.util.UUID": {
                return CdsBaseType.UUID;
            }
            case "java.lang.Integer": {
                return CdsBaseType.INTEGER;
            }
            case "java.lang.Long": {
                return CdsBaseType.INTEGER64;
            }
            case "java.math.BigDecimal": {
                return CdsBaseType.DECIMAL;
            }
            case "java.lang.Float": 
            case "java.lang.Double": {
                return CdsBaseType.DOUBLE;
            }
            case "java.time.LocalDate": {
                return CdsBaseType.DATE;
            }
            case "java.time.LocalTime": {
                return CdsBaseType.TIME;
            }
            case "java.time.Instant": {
                return CdsBaseType.TIMESTAMP;
            }
            case "java.lang.String": {
                return CdsBaseType.STRING;
            }
            case "byte[]": {
                return CdsBaseType.BINARY;
            }
        }
        throw new CdsException("Cannot find CDS base type for Java type '" + javaType + "'");
    }

    public static String cdsTypeShortName(String cdsType) {
        return cdsType.substring(4, cdsType.length()).toLowerCase(Locale.US);
    }

    public static Instant instant(String cdsType, Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Instant) {
            return (Instant)object;
        }
        if (object instanceof ZonedDateTime) {
            return ((ZonedDateTime)object).toInstant();
        }
        if (object instanceof String) {
            return CdsTypeUtils.parseInstant((String)object);
        }
        if (object instanceof java.util.Date) {
            return ((java.util.Date)object).toInstant();
        }
        if (object instanceof Timestamp) {
            return ((Timestamp)object).toInstant();
        }
        String msg = MessageFormat.format("Unexpected Java class for element with type {0}: {1}", cdsType, object.getClass().getName());
        throw new IllegalArgumentException(msg);
    }

    public static LocalDate localDate(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof LocalDate) {
            return (LocalDate)object;
        }
        if (object instanceof String) {
            return CdsTypeUtils.parseDate((String)object);
        }
        if (object instanceof Date) {
            return ((Date)object).toLocalDate();
        }
        if (object instanceof java.util.Date) {
            java.util.Date utilDate = (java.util.Date)object;
            return utilDate.toInstant().atZone(ZULU).toLocalDate();
        }
        throw new CdsDataException("Unexpected Java class for element with type cds.Date: " + object.getClass().getName());
    }

    public static LocalTime localTime(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof LocalTime) {
            return (LocalTime)object;
        }
        if (object instanceof String) {
            return CdsTypeUtils.parseTime((String)object);
        }
        if (object instanceof Time) {
            return ((Time)object).toLocalTime();
        }
        if (object instanceof java.util.Date) {
            java.util.Date utilDate = (java.util.Date)object;
            return utilDate.toInstant().atZone(ZULU).toLocalTime();
        }
        throw new CdsDataException("Unexpected Java class for element with type cds.Time: " + object.getClass().getName());
    }

    public static Instant timestamp(Object object, int precision) {
        return CdsTypeUtils.timestamp(CdsTypeUtils.instant("cds.Timestamp", object), precision);
    }

    public static Instant timestamp(Instant i, int precision) {
        if (i == null) {
            return null;
        }
        int decimals = PWR_OF_TEN[precision - 1];
        int nanos = i.getNano();
        nanos = nanos / decimals * decimals;
        return CdsTypeUtils.truncateToSeconds(i).plusNanos(nanos);
    }

    private static Instant truncateToSeconds(Instant i) {
        long nanosOfDay = i.getEpochSecond() % SECONDS_PER_DAY * NANOS_PER_SECOND + (long)i.getNano();
        long truncated = Math.floorDiv(nanosOfDay, NANOS_PER_SECOND) * NANOS_PER_SECOND;
        return i.plusNanos(truncated - nanosOfDay);
    }

    public static Instant dateTime(Object object) {
        return CdsTypeUtils.dateTime(CdsTypeUtils.instant("cds.DateTime", object));
    }

    public static BigDecimal bigDecimal(Object object) {
        return new BigDecimal(object.toString());
    }

    public static Instant dateTime(Instant i) {
        if (i == null) {
            return null;
        }
        return i.truncatedTo(ChronoUnit.SECONDS);
    }

    public static Long parseLong(String input) {
        if (input == null) {
            throw new CdsDataException("Cannot parse Long as the input is null.");
        }
        return Long.valueOf(input.trim());
    }

    public static Integer parseInteger(String input) {
        if (input == null) {
            throw new CdsDataException("Cannot parse Integer as the input is null.");
        }
        return Integer.valueOf(input.trim());
    }

    public static BigDecimal parseBigDecimal(String input) {
        if (input == null) {
            throw new CdsDataException("Cannot parse BigDecimal as the input is null.");
        }
        return new BigDecimal(input.trim());
    }

    public static Instant parseInstant(String txt) {
        txt = txt.trim();
        try {
            return ZonedDateTime.parse(txt).toInstant();
        }
        catch (DateTimeParseException ex) {
            logger.debug("found non-iso-8601 timestamp: {}", (Object)txt);
            try {
                String[] splits = txt.split("\\s+");
                LocalDate date = LocalDate.parse(splits[0]);
                LocalTime time = LocalTime.parse(splits[1]);
                return LocalDateTime.of(date, time).atZone(ZULU).toInstant();
            }
            catch (DateTimeParseException e) {
                throw new CdsDataException("Cannot parse instant. Text '" + txt + "' is neither ISO 8601 nor ISO/IEC 9075", (Throwable)e);
            }
        }
    }

    public static LocalDate parseDate(String txt) {
        try {
            return LocalDate.parse(txt.trim());
        }
        catch (DateTimeParseException ex) {
            String msg = MessageFormat.format("Value {0} cannot be converted to CDS type cds.Date", txt);
            throw new CdsDataException(msg, (Throwable)ex);
        }
    }

    public static LocalTime parseTime(String txt) {
        try {
            return LocalTime.parse(txt.trim());
        }
        catch (DateTimeParseException ex) {
            String msg = MessageFormat.format("Value {0} cannot be converted to CDS type cds.Time", txt);
            throw new CdsDataException(msg, (Throwable)ex);
        }
    }

    public static boolean isStrictUUID(CdsElement e, CdsType t) {
        return t.isSimpleType(CdsBaseType.UUID) && !"Edm.String".equals(e.getAnnotationValue("@odata.Type", null));
    }

    public static String parseUuid(Object obj) {
        if (obj == null) {
            return null;
        }
        String txt = obj.toString();
        return CdsTypeUtils.parseUuid(txt);
    }

    private static String parseUuid(String txt) {
        return txt.trim().toLowerCase(Locale.US);
    }

    public static Object parse(CdsBaseType type, String txt) {
        if (type == null) {
            return txt;
        }
        if (txt == null) {
            return null;
        }
        try {
            return parsers.get(type).apply(txt);
        }
        catch (IllegalArgumentException ex) {
            String msg = MessageFormat.format("Value {0} cannot be converted to CDS type {1}", txt, type.cdsName());
            throw new CdsDataException(msg, (Throwable)ex);
        }
    }

    private static byte[] parseHex(String s) {
        return BaseEncoding.base16().decode((CharSequence)s.toUpperCase(Locale.US));
    }

    public static String encodeHex(byte[] b) {
        return BaseEncoding.base16().encode(b);
    }

    static {
        parsers.put(CdsBaseType.UUID, CdsTypeUtils::parseUuid);
        parsers.put(CdsBaseType.BOOLEAN, CdsTypeUtils::parseBoolean);
        parsers.put(CdsBaseType.INTEGER, CdsTypeUtils::parseInteger);
        parsers.put(CdsBaseType.INTEGER64, CdsTypeUtils::parseLong);
        parsers.put(CdsBaseType.DECIMAL, CdsTypeUtils::parseBigDecimal);
        parsers.put(CdsBaseType.DECIMAL_FLOAT, CdsTypeUtils::parseBigDecimal);
        parsers.put(CdsBaseType.DOUBLE, Double::parseDouble);
        parsers.put(CdsBaseType.DATE, CdsTypeUtils::parseDate);
        parsers.put(CdsBaseType.TIME, CdsTypeUtils::parseTime);
        parsers.put(CdsBaseType.DATETIME, CdsTypeUtils::parseInstant);
        parsers.put(CdsBaseType.TIMESTAMP, CdsTypeUtils::parseInstant);
        parsers.put(CdsBaseType.STRING, s -> s);
        parsers.put(CdsBaseType.LARGE_STRING, s -> s);
        parsers.put(CdsBaseType.BINARY, CdsTypeUtils::parseHex);
        parsers.put(CdsBaseType.LARGE_BINARY, CdsTypeUtils::parseHex);
        PWR_OF_TEN = new int[]{100000000, 10000000, 1000000, 100000, 10000, 1000, 100, 10, 1};
    }
}

