/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import com.sap.cds.CdsDataProcessor;
import com.sap.cds.CdsException;
import com.sap.cds.SessionContext;
import com.sap.cds.impl.DataProcessor;
import com.sap.cds.impl.localized.LocaleUtils;
import com.sap.cds.impl.util.Pair;
import com.sap.cds.impl.util.StringSplitter;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsArrayedType;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.reflect.impl.DraftAdapter;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.CdsTypeUtils;
import com.sap.cds.util.OnConditionAnalyzer;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataUtils {
    private static final Logger logger = LoggerFactory.getLogger(DataUtils.class);
    private static final String ON_INSERT = "cds.on.insert";
    private static final String ON_ODATA_INSERT = "odata.on.insert";
    private static final String ON_UPDATE = "cds.on.update";
    private static final String ON_ODATA_UPDATE = "odata.on.update";
    private static final CdsDataProcessor uuidKeyNormalizer = DataProcessor.create().addConverter((p, e, t) -> e.isKey() && CdsTypeUtils.isStrictUUID(e, t), (p, e, uuid) -> CdsTypeUtils.parseUuid(uuid));
    private final Supplier<SessionContext> session;
    private final int timestampPrecision;
    private final CdsDataProcessor updateDataSanitizer = DataProcessor.create().forUpdate().bulkAction((t, entries) -> DataUtils.resolvePaths(entries)).addConverter((p, e, t) -> t.isSimpleType(CdsBaseType.DATETIME), (p, e, dt) -> CdsTypeUtils.dateTime(dt)).addConverter((p, e, t) -> t.isSimpleType(CdsBaseType.TIMESTAMP), (p, e, ts) -> this.ts(ts)).addConverter((p, e, t) -> CdsTypeUtils.isStrictUUID(e, t), (p, e, uuid) -> CdsTypeUtils.parseUuid(uuid));
    private final CdsDataProcessor insertDataSanitizer = DataProcessor.create().forInsert().bulkAction((t, entries) -> DataUtils.resolvePaths(entries)).addGenerator((p, e, t) -> DataUtils.hasDefaultValue(e, t), (p, e, isNull) -> isNull ? null : this.defaultValue(e)).addConverter((p, e, t) -> t.isSimpleType(CdsBaseType.DATETIME), (p, e, dt) -> CdsTypeUtils.dateTime(dt)).addConverter((p, e, t) -> t.isSimpleType(CdsBaseType.TIMESTAMP), (p, e, ts) -> this.ts(ts)).addConverter((p, e, t) -> CdsTypeUtils.isStrictUUID(e, t), (p, e, uuid) -> CdsTypeUtils.parseUuid(uuid)).addGenerator((p, e, t) -> e.isKey() && t.isSimpleType(CdsBaseType.UUID), (p, e, isNull) -> UUID.randomUUID().toString());
    private final CdsDataProcessor onInsertGenerator = DataProcessor.create().forInsert().addGenerator((p, e, t) -> DataUtils.hasOnInsertAnnotation(e), (p, e, isNull) -> this.managedValue(e, isNull, new String[]{ON_INSERT, ON_ODATA_INSERT}));
    private final CdsDataProcessor onUpdateGenerator = DataProcessor.create().forUpdate().addGenerator((p, e, t) -> DataUtils.hasOnUpdateAnnotation(e), (p, e, isNull) -> this.managedValue(e, isNull, new String[]{ON_UPDATE, ON_ODATA_UPDATE}));
    private final CdsDataProcessor virtualDataSanitizer = DataProcessor.create().addConverter((p, e, t) -> e.isVirtual(), (p, e, t) -> CdsDataProcessor.Converter.REMOVE);
    private final AnnotationValueSupplier annotationValueSupplier = new AnnotationValueSupplier().addSupplier(v -> v.equals("$now") || v.equals("now"), (session, annotationValue, type) -> ((SessionContext)session.get()).getNow()).addSupplier(v -> v.equals("$user") || v.equals("user"), (session, annotationValue, type) -> ((SessionContext)session.get()).getUserContext().getId()).addSupplier(v -> v.equals("$user.locale"), (session, annotationValue, type) -> LocaleUtils.getLocaleString(((SessionContext)session.get()).getUserContext().getLocale())).addSupplier(v -> v.equals("$user.tenant"), (session, annotationValue, type) -> ((SessionContext)session.get()).getUserContext().getTenant()).addSupplier(v -> v.equals("$uuid"), (session, annotationValue, type) -> UUID.randomUUID().toString()).addSupplier(this::isArbitraryUserAttribute, this::getUserAttributeValue);

    private DataUtils(Supplier<SessionContext> session2, int timestampPrecision) {
        this.session = session2;
        this.timestampPrecision = timestampPrecision;
    }

    private Object ts(Object o) {
        return CdsTypeUtils.timestamp(CdsTypeUtils.instant("cds.Timestamp", o), this.timestampPrecision);
    }

    private static boolean hasOnInsertAnnotation(CdsElement element) {
        return element.findAnnotation(ON_INSERT).isPresent() || element.findAnnotation(ON_ODATA_INSERT).isPresent();
    }

    private static boolean hasOnUpdateAnnotation(CdsElement element) {
        return element.findAnnotation(ON_UPDATE).isPresent() || element.findAnnotation(ON_ODATA_UPDATE).isPresent();
    }

    public static DataUtils create(Supplier<SessionContext> session, int timestampPrecision) {
        return new DataUtils(session, timestampPrecision);
    }

    public static boolean isDeep(CdsStructuredType type, Collection<Map<String, Object>> entries) {
        return type.associations().map(CdsElement::getName).anyMatch(a -> entries.stream().anyMatch(d -> d.containsKey(a)));
    }

    public static boolean hasNonKeyValues(CdsStructuredType type, Map<String, Object> data) {
        if (data.isEmpty()) {
            return false;
        }
        Set<String> keys = CdsModelUtils.keyNames(type);
        return data.keySet().stream().anyMatch(e -> !keys.contains(e));
    }

    public static boolean uniformData(CdsStructuredType type, Collection<Map<String, Object>> entries) {
        if (entries.isEmpty()) {
            return true;
        }
        Set<String> elements = entries.iterator().next().keySet();
        return entries.stream().allMatch(e -> e.keySet().equals(elements));
    }

    public void prepareForInsert(CdsStructuredType struct, List<? extends Map<String, Object>> entries) {
        this.insertDataSanitizer.process(entries, struct);
        this.processOnInsert(struct, entries);
    }

    public void prepareForUpdate(CdsStructuredType struct, List<? extends Map<String, Object>> entries) {
        this.updateDataSanitizer.process(entries, struct);
        this.processOnUpdate(struct, entries, false);
    }

    public void processOnInsert(CdsStructuredType struct, Iterable<? extends Map<String, Object>> data) {
        this.onInsertGenerator.process(data, struct);
    }

    public void processOnUpdate(CdsStructuredType struct, Iterable<? extends Map<String, Object>> data, boolean deep) {
        if (deep) {
            this.onUpdateGenerator.process(data, struct);
        } else {
            HashMap managed = new HashMap();
            struct.concreteElements().filter(CdsAnnotatable.byAnnotation((String)ON_UPDATE).or(CdsAnnotatable.byAnnotation((String)ON_ODATA_UPDATE))).forEach(e -> managed.put(e.getName(), this.managedValue((CdsElement)e, new String[]{ON_UPDATE, ON_ODATA_UPDATE})));
            Streams.stream(data).forEach(e -> managed.forEach((k, v) -> e.putIfAbsent(k, v)));
        }
    }

    public static void resolvePaths(CdsEntity entity, List<? extends Map<String, Object>> entries) {
        DataProcessor.create().bulkAction((t, data) -> DataUtils.resolvePaths(data)).process(entries, (CdsStructuredType)entity);
    }

    public static boolean hasDefaultValue(CdsElement element, CdsType type) {
        return type.isSimple() && element.defaultValue().isPresent() && !DraftAdapter.isDraftElement(element.getName());
    }

    public Object defaultValue(CdsElement e) {
        Object val = e.defaultValue().orElse(null);
        if (val != null && "$now".equalsIgnoreCase(val.toString())) {
            val = this.session.get().getNow();
        }
        return val;
    }

    private static void resolvePaths(Iterable<Map<String, Object>> entries) {
        entries.forEach(entry -> new HashSet(entry.keySet()).forEach(key -> DataUtils.resolvePathAndAdd(entry, key, entry.get(key))));
    }

    public static void resolvePathAndAdd(Map<String, Object> map, String key, Object value) {
        int i = key.indexOf(46);
        if (i == -1) {
            if (value != null) {
                map.put((String)key, (Object)value);
            }
        } else {
            map.remove(key);
            String seg = key.substring(0, i);
            key = key.substring(i + 1);
            if (value == null) {
                if (!map.containsKey(seg)) {
                    map.put(seg, null);
                }
            } else {
                map = (Map)map.computeIfAbsent((String)seg, s -> new HashMap());
                DataUtils.resolvePathAndAdd(map, key, value);
            }
        }
    }

    public static Object putPath(Map<String, Object> map, String key, Object value) {
        int i = key.indexOf(46);
        if (i == -1) {
            return map.put((String)key, (Object)value);
        }
        String seg = key.substring(0, i);
        key = key.substring(i + 1);
        map = (Map)map.computeIfAbsent((String)seg, s -> new HashMap());
        return DataUtils.putPath(map, key, value);
    }

    private Object managedValue(CdsElement e, boolean isNull, String[] annotations) {
        if (isNull) {
            return null;
        }
        return this.managedValue(e, annotations);
    }

    private Object managedValue(CdsElement e, String[] annotations) {
        Object value = DataUtils.getAnnotationValue(e, annotations);
        if (value instanceof Map) {
            Object object = DataUtils.getConvertedAnnotationValue(value);
            String annotationValue = ((String)object).toLowerCase(Locale.ROOT);
            Pair<Boolean, Object> result = this.annotationValueSupplier.supply(e, e.getType(), annotationValue, this.session);
            if (((Boolean)result.left).booleanValue()) {
                return result.right;
            }
            logger.debug("Unsupported managed value '{}' in element {}", object, (Object)e.getQualifiedName());
            return object;
        }
        return value;
    }

    private boolean isArbitraryUserAttribute(String value) {
        return value.startsWith("$user") && "$user".length() + 1 < value.length();
    }

    private Object getUserAttributeValue(Supplier<SessionContext> sessionContext, String annotationValue, CdsType type) {
        String attributeName = this.getUserAttributeName(annotationValue);
        List attributeValues = sessionContext.get().getUserContext().getAttribute(attributeName);
        if (Objects.isNull(attributeValues)) {
            return null;
        }
        if (type.isArrayed() && ((CdsArrayedType)type).getItemsType().isSimpleType(CdsBaseType.STRING)) {
            return new ArrayList(attributeValues);
        }
        if (type.isSimpleType(CdsBaseType.STRING)) {
            if (attributeValues.isEmpty()) {
                return "";
            }
            if (attributeValues.size() == 1) {
                return attributeValues.get(0);
            }
            throw new CdsException("Value list can't be assigned to a non-array type.");
        }
        throw new CdsException("Value list can't be assigned to a non-string type.");
    }

    private String getUserAttributeName(String annotationValue) {
        int index = annotationValue.indexOf(46);
        if (index > 1 && annotationValue.substring(index + 1).length() > 0) {
            return annotationValue.substring(index + 1);
        }
        return "";
    }

    private static Object getAnnotationValue(CdsElement e, String[] annotations) {
        return Arrays.stream(annotations).map(annotation -> e.getAnnotationValue(annotation, null)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private static String getStringAnnotationValue(CdsElement e, String[] annotations) {
        Object value = DataUtils.getAnnotationValue(e, annotations);
        return Objects.nonNull(value) ? DataUtils.getConvertedAnnotationValue(value).toString() : null;
    }

    private static Object getConvertedAnnotationValue(Object annotationValue) {
        Map value = (Map)annotationValue;
        Object result = Optional.ofNullable(value.get("=")).orElse(value.get("#"));
        return result;
    }

    public static List<Instant> dateTimeValues(List<Instant> instants) {
        return instants.stream().map(CdsTypeUtils::dateTime).collect(Collectors.toList());
    }

    public static List<Instant> timestampValues(List<Instant> instants, int precision) {
        return instants.stream().map(i -> CdsTypeUtils.timestamp(i, precision)).collect(Collectors.toList());
    }

    public static boolean generateUuidKeys(CdsStructuredType struct, Map<String, Object> data) {
        int size = data.size();
        DataUtils.generateUuids(struct.keyElements().filter(key -> key.getType().isSimpleType(CdsBaseType.UUID) || key.getType().isSimpleType(CdsBaseType.STRING) && DataUtils.hasManagedUuidValue(key)), Lists.newArrayList((Object[])new Map[]{data}));
        return data.size() > size;
    }

    public static boolean hasManagedUuidValue(CdsElement element) {
        String[] annotations = new String[]{ON_INSERT, ON_ODATA_INSERT};
        return "$uuid".equals(DataUtils.getStringAnnotationValue(element, annotations));
    }

    private static void generateUuids(Stream<CdsElement> elements, Iterable<? extends Map<String, Object>> entries) {
        elements.forEach(e -> DataUtils.parallelStream(entries).forEach(entry -> entry.compute(e.getName(), DataUtils::normalizedUuid)));
    }

    private static String normalizedUuid(String k, Object uuid) {
        return uuid != null ? CdsTypeUtils.parseUuid(uuid) : UUID.randomUUID().toString();
    }

    public static void normalizedUuidKeys(CdsStructuredType type, Iterable<? extends Map<String, Object>> entries) {
        uuidKeyNormalizer.process(entries, type);
    }

    public static Map<String, Object> copyMap(Map<String, ?> original) {
        return original.entrySet().stream().collect(HashMap::new, (m, e) -> m.put(e.getKey(), DataUtils.copyIfListOrMap(e.getValue())), HashMap::putAll);
    }

    private static <T> Stream<T> parallelStream(Iterable<T> entries) {
        return StreamSupport.stream(entries.spliterator(), true);
    }

    public static List copyGenericList(List original) {
        if (!original.isEmpty() && Map.class.isAssignableFrom(original.get(0).getClass())) {
            return original.stream().map(DataUtils::copyMap).collect(Collectors.toList());
        }
        return new ArrayList(original);
    }

    private static Object copyIfListOrMap(Object original) {
        if (original instanceof List) {
            return DataUtils.copyGenericList((List)original);
        }
        if (original instanceof Map) {
            return DataUtils.copyMap((Map)original);
        }
        return original;
    }

    public void removeVirtualElements(CdsStructuredType struct, List<? extends Map<String, Object>> data) {
        this.virtualDataSanitizer.process(data, struct);
    }

    public static void merge(List<? extends Map<String, Object>> source, List<? extends Map<String, Object>> target, String expRefName, Map<String, String> mapping, String fkPrefix) {
        Map<String, List<Map>> groupedTarget = target.stream().collect(Collectors.groupingBy(row -> DataUtils.groupId(mapping.keySet(), row)));
        source.forEach(row -> {
            String groupId = DataUtils.groupId(mapping.values(), row);
            List list = groupedTarget.getOrDefault(groupId, new ArrayList(0));
            list.forEach(r -> r.keySet().removeIf(k -> k.startsWith(fkPrefix)));
            row.put(expRefName, list);
        });
    }

    public static Stream<String> deepMapKeys(Map<String, ?> map) {
        return DataUtils.prefixedKeys("", map);
    }

    private static Stream<String> prefixedKeys(String prefix, Map<String, ?> map) {
        return map.entrySet().stream().flatMap(e -> DataUtils.prefixedKeys(prefix, (String)e.getKey(), e.getValue()));
    }

    private static Stream<String> prefixedKeys(String prefix, String key, Object value) {
        if (value instanceof Map) {
            return DataUtils.prefixedKeys(prefix + key + ".", (Map)value);
        }
        return Stream.of(prefix + key);
    }

    private static String groupId(Collection<String> mapping, Map<String, Object> values) {
        return mapping.stream().map(k -> Objects.toString(values.get(k))).collect(Collectors.joining("#"));
    }

    public static Map<String, Object> keyValues(CdsEntity entity, Map<String, Object> data) {
        HashMap<String, Object> keyValues = new HashMap<String, Object>();
        Set<String> keyNames = CdsModelUtils.keyNames((CdsStructuredType)entity);
        keyNames.forEach(k -> {
            if (data.containsKey(k)) {
                keyValues.put((String)k, data.get(k));
            } else {
                String path = k.replace("_", ".");
                Object val = DataUtils.getOrDefault(data, path, null);
                keyValues.put((String)k, val);
            }
        });
        return keyValues;
    }

    public static <T> T getOrDefault(Map<String, Object> data, String path, T defaultValue) {
        if (data.containsKey(path)) {
            return (T)data.get(path);
        }
        return DataUtils.getPathOrDefault(data, path, defaultValue);
    }

    public static <T> T getPathOrDefault(Map<String, Object> data, String path, T defaultValue) {
        if (!data.isEmpty()) {
            Map d = data;
            String[] segment = StringSplitter.split(path, '.');
            for (int i = 0; i < segment.length; ++i) {
                String k = segment[i];
                if (i + 1 == segment.length) {
                    return (T)d.getOrDefault(k, defaultValue);
                }
                if ((d = (Map)d.get(k)) != null) continue;
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public static <T> T removePath(Map<String, Object> data, String path, boolean removeEmptyMaps) {
        int lastDot = path.lastIndexOf(".");
        if (lastDot == -1) {
            return (T)data.remove(path);
        }
        String key = path.substring(lastDot + 1);
        Map map = DataUtils.getPathOrDefault(data, path = path.substring(0, lastDot), null);
        if (map != null) {
            Object value = map.remove(key);
            if (removeEmptyMaps && map.isEmpty()) {
                DataUtils.removePath(data, path, removeEmptyMaps);
            }
            return (T)value;
        }
        return null;
    }

    public static boolean containsKey(Map<String, Object> data, String path) {
        return DataUtils.containsKey(data, path, false);
    }

    public static boolean containsKey(Map<String, Object> data, String path, boolean propagateNull) {
        if (data.containsKey(path)) {
            return true;
        }
        if (data.isEmpty()) {
            return false;
        }
        String[] segments = StringSplitter.split(path, '.');
        Map d = data;
        for (int i = 0; i < segments.length; ++i) {
            String segment = segments[i];
            boolean contained = d.containsKey(segment);
            if (!contained || i + 1 == segments.length) {
                return contained;
            }
            if ((d = (Map)d.get(segment)) != null) continue;
            return propagateNull;
        }
        return false;
    }

    public static int hash(Map<String, Object> values, Set<String> keys) {
        int hash = 7;
        for (String key : keys) {
            hash = 31 * hash + Objects.hash(key, values.get(key));
        }
        return hash;
    }

    public static boolean isFkUpdate(CdsElement assoc, Map<String, Object> data, SessionContext session) {
        Map<String, Object> refValues = new OnConditionAnalyzer(assoc, false, session).getFkValues(data);
        return refValues.size() == data.size() && !refValues.containsValue(null);
    }

    private static class AnnotationValueSupplier {
        private final List<Pair<Function<String, Boolean>, TriFunction<Supplier<SessionContext>, String, CdsType, Object>>> generators = new ArrayList<Pair<Function<String, Boolean>, TriFunction<Supplier<SessionContext>, String, CdsType, Object>>>();

        private AnnotationValueSupplier() {
        }

        AnnotationValueSupplier addSupplier(Function<String, Boolean> filter, TriFunction<Supplier<SessionContext>, String, CdsType, Object> supplier) {
            this.generators.add(Pair.of(filter, supplier));
            return this;
        }

        public Pair<Boolean, Object> supply(CdsElement e, CdsType type, String annotationValue, Supplier<SessionContext> session) {
            for (Pair<Function<String, Boolean>, TriFunction<Supplier<SessionContext>, String, CdsType, Object>> generator : this.generators) {
                if (!((Boolean)((Function)generator.left).apply(annotationValue)).booleanValue()) continue;
                return Pair.of(true, ((TriFunction)generator.right).apply(session, annotationValue, type));
            }
            return Pair.of(false, null);
        }

        @FunctionalInterface
        static interface TriFunction<A, B, C, R> {
            public R apply(A var1, B var2, C var3);
        }
    }
}

